import { Attributes } from "graphology-types";
import { Settings } from "../../settings.js";
import Sigma from "../../sigma.js";
import { CameraState, MouseCoords, WheelCoords } from "../../types.js";
import Captor from "./captor.js";
export declare const MOUSE_SETTINGS_KEYS: readonly ["doubleClickTimeout", "doubleClickZoomingDuration", "doubleClickZoomingRatio", "dragTimeout", "draggedEventsTolerance", "inertiaDuration", "inertiaRatio", "zoomDuration", "zoomingRatio"];
export type MouseSettingKey = (typeof MOUSE_SETTINGS_KEYS)[number];
export type MouseSettings = Pick<Settings, MouseSettingKey>;
export declare const DEFAULT_MOUSE_SETTINGS: MouseSettings;
export type MouseCaptorEvents = {
    click(coordinates: MouseCoords): void;
    rightClick(coordinates: MouseCoords): void;
    doubleClick(coordinates: MouseCoords): void;
    mouseup(coordinates: MouseCoords): void;
    mousedown(coordinates: MouseCoords): void;
    mousemove(coordinates: MouseCoords): void;
    mousemovebody(coordinates: MouseCoords): void;
    mouseleave(coordinates: MouseCoords): void;
    mouseenter(coordinates: MouseCoords): void;
    wheel(coordinates: WheelCoords): void;
};
export default class MouseCaptor<N extends Attributes = Attributes, E extends Attributes = Attributes, G extends Attributes = Attributes> extends Captor<MouseCaptorEvents, N, E, G> {
    enabled: boolean;
    draggedEvents: number;
    downStartTime: number | null;
    lastMouseX: number | null;
    lastMouseY: number | null;
    isMouseDown: boolean;
    isMoving: boolean;
    movingTimeout: number | null;
    startCameraState: CameraState | null;
    clicks: number;
    doubleClickTimeout: number | null;
    currentWheelDirection: -1 | 0 | 1;
    lastWheelTriggerTime?: number;
    settings: MouseSettings;
    constructor(container: HTMLElement, renderer: Sigma<N, E, G>);
    kill(): void;
    handleClick(e: MouseEvent): void;
    handleRightClick(e: MouseEvent): void;
    handleDoubleClick(e: MouseEvent): void;
    handleDown(e: MouseEvent): void;
    handleUp(e: MouseEvent): void;
    handleMove(e: MouseEvent): void;
    handleLeave(e: MouseEvent): void;
    handleEnter(e: MouseEvent): void;
    handleWheel(e: WheelEvent): void;
    setSettings(settings: MouseSettings): void;
}
