<?php
/***********************************************************************
 * This Source Code Form is subject to the terms of the Mozilla Public *
 * License, v. 2.0. If a copy of the MPL was not distributed with this *
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.            *
 ***********************************************************************/

ini_set('default_charset', 'utf-8');

$lang = array(
    'Home'=>'Home',
    'RiskManagement'=>'Risk Management',
    'Reporting'=>'Reporting',
    'Configure'=>'Configure',
    'MyProfile'=>'My Profile',
    'Logout'=>'Logout',
    'LogInHere'=>'Login to SimpleRisk',
    'Username'=>'Username',
    'Password'=>'Password',
    'ForgotYourPassword'=>'Forgot your password',
    'Login'=>'Login',
    'Reset'=>'Reset',
    'Send'=>'Send',
    'Update'=>'Update',
    'SendPasswordResetEmail'=>'Send Password Reset Email',
    'PasswordReset'=>'Password Reset',
    'ResetToken'=>'Reset Token',
    'RepeatPassword'=>'Repeat Password',
    'Submit'=>'Submit',
    'ProfileDetails'=>'Profile Details',
    'LastLogin'=>'Last Login',
    'ChangePassword'=>'Change Password',
    'CurrentPassword'=>'Current Password',
    'NewPassword'=>'New Password',
    'ConfirmPassword'=>'Confirm Password',
    'ConfigureRiskFormula'=>'Configure Risk Formula',
    'ConfigureReviewSettings'=>'Configure Review Settings',
    'AddAndRemoveValues'=>'Add and Remove Values',
    'UserManagement'=>'User Management',
    'RedefineNamingConventions'=>'Redefine Naming Conventions',
    'AuditTrail'=>'Audit Trail',
    'Extras'=>'Extras',
    'Announcements'=>'Announcements',
    'About'=>'About',
    'Impact'=>'Impact',
    'Likelihood'=>'Likelihood',
    'MitigationEffort'=>'Mitigation Effort',
    'Change'=>'Change',
    'to'=>'to',
    'AddANewUser'=>'Add a New User',
    'Type'=>'Type',
    'FullName'=>'Full Name',
    'EmailAddress'=>'E-mail Address',
    'Teams'=>'Team(s)',
    'ALL'=>'ALL',
    'NONE'=>'NONE',
    'UserResponsibilities'=>'User Responsibilities',
    'AbleToSubmitNewRisks'=>'Able to Submit New Risks',
    'AbleToModifyExistingRisks'=>'Able to Modify Risk Details',
    'AbleToCloseRisks'=>'Able to Close Risks',
    'AbleToPlanMitigations'=>'Able to Plan Mitigations',
    'AbleToReviewLowRisks'=>'Able to Review Low Risks',
    'AbleToReviewMediumRisks'=>'Able to Review Medium Risks',
    'AbleToReviewHighRisks'=>'Able to Review High Risks',
    'AllowAccessToConfigureMenu'=>'Allow Access to "Configure" Menu',
    'MultiFactorAuthentication'=>'Multi-Factor Authentication',
    'None'=>'None',
    'Add'=>'Add',
    'ViewDetailsForUser'=>'View Details for User',
    'DetailsForUser'=>'Details for User',
    'Select'=>'Select',
    'EnableAndDisableUsers'=>'Enable and Disable Users',
    'EnableAndDisableUsersHelp'=>'Use this feature to enable or disable user logins while maintaining the audit trail of user activities',
    'DisableUser'=>'Disable user',
    'Disable'=>'Disable',
    'EnableUser'=>'Enable user',
    'Enable'=>'Enable',
    'DeleteAnExistingUser'=>'Delete an Existing User',
    'DeleteCurrentUser'=>'Delete current user',
    'Delete'=>'Delete',
    'SendPasswordResetEmailForUser'=>'Send password reset email for user',
    'Category'=>'Category',
    'AddNewCategoryNamed'=>'Add new category named',
    'DeleteCurrentCategoryNamed'=>'Delete current category named',
    'Team'=>'Team',
    'AddNewTeamNamed'=>'Add new team named',
    'DeleteCurrentTeamNamed'=>'Delete current team named',
    'Technology'=>'Technology',
    'AddNewTechnologyNamed'=>'Add new technology named',
    'DeleteCurrentTechnologyNamed'=>'Delete current technology named',
    'SiteLocation'=>'Site/Location',
    'AddNewSiteLocationNamed'=>'Add new site/location named',
    'DeleteCurrentSiteLocationNamed'=>'Delete current site/location named',
    'ControlRegulation'=>'Control Regulation',
    'AddNewControlRegulationNamed'=>'Add new control regulation named',
    'DeleteCurrentControlRegulationNamed'=>'Delete current control regulation named',
    'RiskPlanningStrategy'=>'Risk Planning Strategy',
    'AddNewRiskPlanningStrategyNamed'=>'Add new risk planning strategy named',
    'DeleteCurrentRiskPlanningStrategyNamed'=>'Delete current risk planning strategy named',
    'CloseReason'=>'Close Reason',
    'AddNewCloseReasonNamed'=>'Add new close reason named',
    'DeleteCurrentCloseReasonNamed'=>'Delete current close reason named',
    'IWantToReviewHighRiskEvery'=>'I want to review HIGH risk every',
    'IWantToReviewMediumRiskEvery'=>'I want to review MEDIUM risk every',
    'IWantToReviewLowRiskEvery'=>'I want to review LOW risk every',
    'days'=>'days',
    'MyClassicRiskFormulaIs'=>'My Classic Risk Formula Is',
    'RISK'=>'RISK',
    'IConsiderHighRiskToBeAnythingGreaterThan'=>'I consider HIGH risk to be anything greater than or equal to',
    'IConsiderMediumRiskToBeLessThanAboveButGreaterThan'=>'I consider MEDIUM risk to be less than above, but greater than or equal to',
    'IConsiderlowRiskToBeLessThanAboveButGreaterThan'=>'I consider LOW risk to be less than above, but greater than or equal to',
    'HighRisk'=>'High Risk',
    'MediumRisk'=>'Medium Risk',
    'LowRisk'=>'Low Risk',
    'Irrelevant'=>'Irrelevant',
    'SubmitYourRisks'=>'Submit Risk',
    'PlanYourMitigations'=>'Plan Mitigation',
    'PerformManagementReviews'=>'Perform Reviews',
    'PrioritizeForProjectPlanning'=>'Plan Projects',
    'ReviewRisksRegularly'=>'Review Regularly',
    'DocumentANewRisk'=>'Document a New Risk',
    'UseThisFormHelp'=>'Use this form in order to document a new risk for consideration in the Risk Management Process',
    'Subject'=>'Subject',
    'ExternalReferenceId'=>'External Reference ID',
    'ControlNumber'=>'Control Number',
    'Owner'=>'Owner',
    'OwnersManager'=>'Owner\'s Manager',
    'RiskScoringMethod'=>'Risk Scoring Method',
    'CurrentLikelihood'=>'Current Likelihood',
    'CurrentImpact'=>'Current Impact',
    'RiskAssessment'=>'Risk Assessment',
    'AdditionalNotes'=>'Additional Notes',
    'UNREVIEWED'=>'UNREVIEWED',
    'PASTDUE'=>'PAST DUE',
    'ID'=>'ID',
    'Status'=>'Status',
    'Risk'=>'Risk',
    'DaysOpen'=>'Days Open',
    'CalculatedRisk'=>'Calculated Risk',
    'SubmittedBy'=>'Submitted By',
    'NextReviewDate'=>'Next Review Date',
    'CVSSRiskScoring'=>'CVSS Risk Scoring',
    'DREADRiskScoring'=>'DREAD Risk Scoring',
    'OWASPRiskScoring'=>'OWASP Risk Scoring',
    'CustomRiskScoring'=>'Custom Risk Scoring',
    'MitigationPlanningHelp'=>'Below is the list of submitted risks that require mitigation planning',
    'ManagementReviewHelp'=>'Below is the list of submitted risks that require a management review',
    'Submitted'=>'Submitted',
    'MitigationPlanned'=>'Mitigation Planned',
    'ManagementReview'=>'Management Review',
    'No'=>'No',
    'Yes'=>'Yes',
    'AddAndRemoveProjects'=>'Add and Remove Projects',
    'AddAndRemoveProjectsHelp'=>'Add and remove projects in order to associate multiple risks together for prioritization',
    'AddNewProjectNamed'=>'Add new project named',
    'DeleteCurrentProjectNamed'=>'Delete current project named',
    'AddUnassignedRisksToProjects'=>'Add Unassigned Risks to Projects',
    'AddUnassignedRisksToProjectsHelp'=>'Drag and drop unassigned risks marked for consideration as a project into the appropriate project tab',
    'PrioritizeProjects'=>'Prioritize Projects',
    'PrioritizeProjectsHelp'=>'Move projects around and change the order of prioritization.  Once finished, don\'t forget to press the "Update" button to save your changes',
    'SaveRisksToProjects'=>'Save Risks to Projects',
    'RiskId'=>'Risk ID',
    'RiskActions'=>'Actions',
    'ReopenRisk'=>'Reopen Risk',
    'CloseRisk'=>'Close Risk',
    'EditRisk'=>'Edit Risk',
    'PlanAMitigation'=>'Plan a Mitigation',
    'PerformAReview'=>'Perform a Review',
    'AddAComment'=>'Add a Comment',
    'ShowRiskScoringDetails'=>'View Risk Scoring Details',
    'HideRiskScoringDetails'=>'Hide Risk Scoring Details',
    'Details'=>'Details',
    'SubmissionDate'=>'Submission Date',
    'DateSubmitted'=>'Date Submitted',
    'EditDetails'=>'Edit Details',
    'Mitigation'=>'Mitigation',
    'MitigationDate'=>'Mitigation Submission Date',
    'PlanningStrategy'=>'Planning Strategy',
    'CurrentSolution'=>'Current Solution',
    'SecurityRequirements'=>'Security Requirements',
    'SecurityRecommendations'=>'Security Recommendations',
    'EditMitigation'=>'Edit Mitigation',
    'LastReview'=>'Last Review',
    'ReviewDate'=>'Review Date',
    'Reviewer'=>'Reviewer',
    'Review'=>'Review',
    'NextStep'=>'Next Step',
    'Comments'=>'Comments',
    'ViewAllReviews'=>'View All Reviews',
    'ReviewHistory'=>'Review History',
    'Comment'=>'Comment',
    'ClassicRiskScoring'=>'Classic Risk Scoring',
    'RiskScoringActions'=>'Risk Scoring Actions',
    'UpdateClassicScore'=>'Update Classic Score',
    'ScoreBy'=>'Score by',
    'RISKClassicExp1'=>'RISK = ( Likelihood x Impact + 2(Impact) )',
    'RISKClassicExp2'=>'RISK = ( Likelihood x Impact + Impact )',
    'RISKClassicExp3'=>'RISK = ( Likelihood x Impact )',
    'RISKClassicExp4'=>'RISK = ( Likelihood x Impact + Likelihood )',
    'RISKClassicExp5'=>'RISK = ( Likelihood x Impact + 2(Likelihood) )',
    'Reason'=>'Reason',
    'CloseOutInformation'=>'Close-Out Information',
    'SubmitManagementReview'=>'Submit Management Review',
    'SubmitRiskMitigation'=>'Submit Risk Mitigation',
    'RiskDashboard'=>'Risk Dashboard',
    'RiskTrend'=>'Risk Trend',
    'AllOpenRisksAssignedToMeByRiskLevel'=>'All Open Risks Assigned to Me',
    'AllOpenRisksByRiskLevel'=>'All Open Risks by Risk Level',
    'AllOpenRisksConsideredForProjectsByRiskLevel'=>'All Open Risks Considered for Projects by Risk Level',
    'AllOpenRisksAcceptedUntilNextReviewByRiskLevel'=>'All Open Risks Accepted Until Next Review by Risk Level',
    'AllOpenRisksToSubmitAsAProductionIssueByRiskLevel'=>'All Open Risks to Submit as a Production Issue by Risk Level',
    'AllOpenRisksByScoringMethod'=>'All Open Risks by Scoring Method',
    'AllClosedRisksByRiskLevel'=>'All Closed Risks by Risk Level',
    'SubmittedRisksByDate'=>'Submitted Risks By Date',
    'MitigationsByDate'=>'Mitigations By Date',
    'ManagementReviewsByDate'=>'Management Reviews By Date',
    'ProjectsAndRisksAssigned'=>'Projects and Risks Assigned',
    'OpenRisks'=>'Open Risks',
    'ClosedRisks'=>'Closed Risks',
    'ReportMyOpenHelp'=>'This report shows all open risks that have the current user as the owner or manager associated with the risk ordered by risk level',
    'ReportOpenHelp'=>'This report shows all open risks ordered by risk level',
    'ReportProjectsHelp'=>'This report shows all open risks considered for projects ordered by risk level',
    'ReportNextReviewHelp'=>'This report shows all open risks accepted until next review ordered by risk level',
    'ReportProductionIssuesHelp'=>'This report shows all open risks submitted as production issues ordered by risk level',
    'ReportRiskScoringHelp'=>'This report shows all risk scoring methods and the risks scored using each',
    'ReportClosedHelp'=>'This report shows all closed risks ordered by risk level',
    'ReportSubmittedByDateHelp'=>'This report shows all risks ordered by submission date',
    'ReportMitigationsByDateHelp'=>'This report shows all mitigations planned ordered by mitigation date',
    'ReportMgmtReviewsByDateHelp'=>'This report shows all management reviews ordered by review date',
    'ReportProjectsAndRisksHelp'=>'This report shows all projects and the risks assigned to them',
    'Language'=>'Language',
    'AllOpenRisksNeedingReview'=>'All Open Risks Needing a Review',
    'ReportReviewNeededHelp'=>'This report shows all open risks needing a management review',
    'CustomValue'=>'Custom Value',
    'ClosedRisksByDate'=>'Closed Risks By Date',
    'DateClosed'=>'Date Closed',
    'ClosedBy'=>'Closed By',
    'ReportClosedByDateHelp'=>'This report shows all risks ordered by closure date',
    'AllOpenRisksByTeam'=>'All Open Risks by Team',
    'ReportRiskTeamsHelp'=>'This report shows all teams and the risks assigned to each',
    'Unassigned'=>'Unassigned',
    'AllOpenRisksByTechnology'=>'All Open Risks By Technology',
    'ReportRiskTechnologiesHelp'=>'This report shows all technologies and the risks assigned to each',
    'RiskLevel'=>'Risk Level',
    'BasedOnTheCurrentRiskScore'=>'Based on your Risk Score, your next review date will be ',
    'WouldYouLikeToUseADifferentDate'=>'Would you like to use a different date instead?',
    'RisksOpenedAndClosedOverTime'=>'Risks Opened and Closed Over Time',
    'AllRiskScoresAreAdjusted'=>'All risk scores are adjusted to fit on a 0-10 scale.',
    'DetermineProjectStatus'=>'Determine Project Status',
    'ProjectStatusHelp'=>'Place projects into buckets based on their current status.',
    'ActiveProjects'=>'Active Projects',
    'OnHoldProjects'=>'On Hold Projects',
    'CompletedProjects'=>'Completed Projects',
    'CancelledProjects'=>'Cancelled Projects',
    'UpdateProjectStatuses'=>'Update Project Statuses',
    'HighRiskReport'=>'High Risk Report',
    'TotalOpenRisks'=>'Total Open Risks',
    'NumberOfOpenRisks'=>'Total Open Risks: {$number}',
    'RiskNumberOfRiskLevel'=>'Total number of {$display_name} Risks: {$number}',
    'RiskPercentageOfRiskLevel'=>'{$display_name} Risk Percentage: {$percentage}%',
    'RiskScoreUsing'=>'Risk Score Using:',
    'HighRiskReport_ScoreWarning' => 'Please note, that even though the report is displayed using the "{$score_used}" scores, because of the "{$next_review_date_uses_name}" setting we\'re calculating the "{$management_review_header}" column\'s values using the "{$next_review_date_uses_value}" scores.',
    'UpdateCVSSScore'=>'Update CVSS Score',
    'BaseScoreMetrics'=>'Base Score Metrics',
    'AttackVector'=>'Attack Vector',
    'AttackComplexity'=>'Attack Complexity',
    'Authentication'=>'Authentication',
    'ConfidentialityImpact'=>'Confidentiality Impact',
    'IntegrityImpact'=>'Integrity Impact',
    'AvailabilityImpact'=>'Availability Impact',
    'TemporalScoreMetrics'=>'Temporal Score Metrics',
    'Exploitability'=>'Exploitability',
    'RemediationLevel'=>'Remediation Level',
    'ReportConfidence'=>'Report Confidence',
    'EnvironmentalScoreMetrics'=>'Environmental Score Metrics',
    'CollateralDamagePotential'=>'Collateral Damage Potential',
    'TargetDistribution'=>'Target Distribution',
    'ConfidentialityRequirement'=>'Confidentiality Requirement',
    'IntegrityRequirement'=>'Integrity Requirement',
    'AvailabilityRequirement'=>'Availability Requirement',
    'UpdateDREADScore'=>'Update DREAD Score',
    'DamagePotential'=>'Damage Potential',
    'Reproducibility'=>'Reproducibility',
    'AffectedUsers'=>'Affected Users',
    'Discoverability'=>'Discoverability',
    'UpdateOWASPScore'=>'Update OWASP Score',
    'ThreatAgentFactors'=>'Threat Agent Factors',
    'SkillLevel'=>'Skill Level',
    'Motive'=>'Motive',
    'Opportunity'=>'Opportunity',
    'Size'=>'Size',
    'VulnerabilityFactors'=>'Vulnerability Factors',
    'EaseOfDiscovery'=>'Ease of Discovery',
    'EaseOfExploit'=>'Ease of Exploit',
    'Awareness'=>'Awareness',
    'IntrusionDetection'=>'Intrusion Detection',
    'TechnicalImpact'=>'Technical Impact',
    'LossOfConfidentiality'=>'Loss of Confidentiality',
    'LossOfIntegrity'=>'Loss of Integrity',
    'LossOfAvailability'=>'Loss of Availability',
    'LossOfAccountability'=>'Loss of Accountability',
    'BusinessImpact'=>'Business Impact',
    'FinancialDamage'=>'Financial Damage',
    'ReputationDamage'=>'Reputation Damage',
    'NonCompliance'=>'Non-Compliance',
    'PrivacyViolation'=>'Privacy Violation',
    'UpdateCustomScore'=>'Update Custom Score',
    'ManuallyEnteredValue'=>'Manually Entered Value',
    'ScoreByClassic'=>'Score by Classic',
    'ScoreByCVSS'=>'Score by CVSS',
    'ScoreByDREAD'=>'Score by DREAD',
    'ScoreByOWASP'=>'Score by OWASP',
    'ScoreByCustom'=>'Score by Custom',
    'BaseVector'=>'Base Vector',
    'TemporalVector'=>'Temporal Vector',
    'EnvironmentalVector'=>'Environmental Vector',
    'SupportingDocumentation'=>'Supporting Documentation',
    'Import'=>'Import',
    'Export'=>'Export',
    'ActivateTheImportExportExtra'=>'Activate the Import/Export Extra',
    'PrintableView'=>'Printable View',
    'GroupBy'=>'Group By',
    'IncludedColumns'=>'Included Columns',
    'AllRisks'=>'All Risks',
    'DynamicRiskReport'=>'Dynamic Risk Report',
    'ObsoleteReports'=>'Obsolete Reports',
    'Project'=>'Project',
    'SortBy'=>'Sort By',
    'MonthSubmitted'=>'Month Submitted',
    'AssetManagement'=>'Asset Management',
    'AutomatedDiscovery'=>'Automated Discovery',
    'BatchImport'=>'Batch Import',
    'ManageAssets'=>'Manage Assets',
    'AssetValuation'=>'Asset Valuation',
    'AllowAccessToAssetManagementMenu'=>'Allow Access to "Asset Management" Menu',
    'AutomatedDiscoveryHelp'=>'Discover all live IP addresses in the entered IP range.  Live IP addresses will be added to the asset list.  Acceptable formats:',
    'IPRange'=>'IP Range',
    'Search'=>'Search',
    'AddANewAsset'=>'Add a New Asset',
    'AssetName'=>'Asset Name',
    'IPAddress'=>'IP Address',
    'AssetWasAddedSuccessfully'=>'Asset was added successfully.',
    'AssetWasDeletedSuccessfully'=>'Asset was deleted successfully.',
    'ThereWasAProblemAddingTheAsset'=>'There was a problem adding the asset.',
    'ThereWasAProblemDeletingTheAsset'=>'There was a problem deleting the asset.',
    'ComingSoon'=>'Coming Soon',
    'ExportRisks'=>'Export Risks',
    'ExportMitigations'=>'Export Mitigations',
    'ExportReviews'=>'Export Reviews',
    'ExportCombined'=>'Export Combined',
    'MitigatedBy'=>'Mitigated By',
    'MitigationId'=>'Mitigation ID',
    'ReviewId'=>'Review ID',
    'AffectedAssets'=>'Affected Assets',
    'Activate'=>'Activate',
    'DeleteRisks'=>'Delete Risks',
    'DeletedRisksCannotBeRecovered'=>'Deleted Risks Cannot Be Recovered',
    'RisksDeletedSuccessfully'=>'Risk(s) Deleted Successfully',
    'ThereWasAProblemDeletingTheRisk'=>'There Was a Problem Deleting the Risk(s)',
    'Activated'=>'ACTIVATED',
    'IWantToReviewInsignificantRiskEvery'=>'I want to review INSIGNIFICANT risk every',
    'Insignificant'=>'Insignificant',
    'IConsiderVeryHighRiskToBeAnythingGreaterThan'=>'I consider VERY HIGH risk to be anything greater than or equal to',
    'IConsiderHighRiskToBeLessThanAboveButGreaterThan'=>'I consider HIGH risk to be less than above, but greater than or equal to',
    'VeryHigh'=>'Very High',
    'VeryHighRisk'=>'Very High Risk',
    'IWantToReviewVeryHighRiskEvery'=> 'I want to review VERY HIGH risk every',
    'AbleToReviewVeryHighRisks'=>'Able to Review Very High Risks',
    'AbleToReviewInsignificantRisks'=>'Able to Review Insignificant Risks',
    'AllTeams'=>'All Teams',
    'FileUploadSettings'=>'File Upload Settings',
    'AllowedFileTypes'=>'Allowed File Types',
    'AddNewFileTypeOf'=>'Add new file type of',
    'DeleteCurrentFileTypeOf'=>'Delete current file type of',
    'MaximumUploadFileSize'=>'Maximum Upload File Size',
    'Bytes'=>'Bytes',
    'CheckAll'=>'Check All',
    'CheckAllRiskMgmt'=>'Check All Risk Management',
    'CheckAllAssetMgmt'=>'Check All Asset Management',
    'CheckAllConfigure'=>'Check All Configure',
    'MitigationTeam'=>'Mitigation Team',
    'ImportRisks'=>'Import Risks',
    'ImportAssets'=>'Import Assets',
    'AssetValue'=>'Asset Value',
    'Register'=>'Register',
    'RegisterSimpleRisk'=>'Register SimpleRisk',
    'RegistrationText'=>'Registered SimpleRisk instances are immediately granted access to the Upgrade and Secure Controls Framework (SCF) Extras.  The Upgrade Extra provides the ability to back up and upgrade your SimpleRisk instance with the click of a button.  The Secure Controls Framework (SCF) Extra provides a common control framework that is integrated into the SimpleRisk Governance functionality.  Upon registering SimpleRisk, your registration information will be sent to a server hosted by SimpleRisk.  The registration information provided will be used by SimpleRisk to notify customers of new releases and security updates.  The act of registering SimpleRisk will opt you into our marketing communications, but you may opt out at any time using the unsubscribe link in these communications.  SimpleRisk respects the privacy of our customers and information provided to us through the SimpleRisk registration process will never be sold to a third-party.',
    'RegistrationInformation'=>'Registration Information',
    'Company'=>'Company',
    'JobTitle'=>'Job Title',
    'Phone'=>'Phone',
    'UpgradeSimpleRisk'=>'Upgrade SimpleRisk',
    'UpgradeInstructions'=>'This section uses the Upgrade Extra.  To make sure you have the latest version, select "Update", re-register, and reload this page.',
    'NoUpgradeNeeded'=>'No upgrade is needed at this time.',
    'BackupDatabaseButton'=>'Backup the Database',
    'UpgradeApplication'=>'Upgrade the Application',
    'UpgradeDatabase'=>'Upgrade the Database',
    'CustomExtras'=>'Custom Extras',
    'CustomExtrasText'=>'It would be awesome if everything were free, right?  Hopefully the core SimpleRisk platform is able to serve all of your risk management needs.  But, if you find yourself still wanting more functionality, we\'ve developed a series of "Extras" that will do just that.',
    'Upgrade'=>'Upgrade',
    'Install'=>'Install',
    'Purchase'=>'Purchase',
    'PasswordPolicy'=>'Password Policy',
    'MinimumNumberOfCharacters'=>'Minimum Number of Characters',
    'RequireAlphaCharacter'=>'Require Alpha Character',
    'RequireUpperCaseCharacter'=>'Require Upper Case Character',
    'RequireLowerCaseCharacter'=>'Require Lower Case Character',
    'RequireNumericCharacter'=>'Require Numeric Character',
    'RequireSpecialCharacter'=>'Require Special Character',
    'Enabled'=>'Enabled',
    'RiskAdvice'=>'Risk Advice',
    'AddDeleteAssets'=>'Add & Delete Assets',
    'EditAssets'=>'Edit Assets',
    'AutomaticAssetValuation'=>'Automatic Asset Valuation',
    'ManualAssetValuation'=>'Manual Asset Valuation',
    'MinimumValue'=>'Minimum Value',
    'MaximumValue'=>'Maximum Value',
    'ValueRange'=>'Value Range',
    'DefaultAssetValuation'=>'Default Asset Valuation',
    'Default'=>'Default',
    'RisksAndAssets'=>'Risks and Assets',
    'Report'=>'Report',
    'RisksByAsset'=>'Risks by Asset',
    'AssetsByRisk'=>'Assets by Risk',
    'MaximumQuantitativeLoss'=>'Maximum Quantitative Loss',
    'MitigationOwner'=>'Mitigation Owner',
    'MitigationCost'=>'Mitigation Cost',
    'RiskColumns'=>'Risk Columns',
    'MitigationColumns'=>'Mitigation Columns',
    'ReviewColumns'=>'Review Columns',
    'ChangeStatus'=>'Change Status',
    'SetRiskStatusTo'=>'Set Risk Status To',
    'AddNewStatusNamed'=>'Add new status named',
    'DeleteStatusNamed' =>'Delete status named',
    'DefaultCurrencySymbol'=>'Default Currency Symbol',
    'DefaultValues'=>'Default Values',
    'RiskSource'=>'Risk Source',
    'AddNewSourceNamed'=>'Add new source named',
    'DeleteSourceNamed'=>'Delete source named',
    'CheckAllAssessments'=>'Check All Assessments',
    'AllowAccessToAssessmentsMenu'=>'Allow Access to "Assessments" Menu',
    'Assessments'=>'Assessments',
    'PendingRisks'=>'Pending Risks',
    'CreateAssessment'=>'Create Assessment',
    'EditAssessment'=>'Edit Assessment',
    'Overview'=>'Overview',
    'OpenVsClosed'=>'Open vs Closed',
    'MitigatedVsUnmitigated'=>'Mitigated vs Unmitigated',
    'ReviewedVsUnreviewed'=>'Reviewed vs Unreviewed',
    'OpenedRisks'=>'Opened Risks',
    'MailSettings'=>'Mail Settings',
    'TransportAgent'=>'Transport Agent',
    'FromName'=>'From Name',
    'FromEmail'=>'From Email',
    'ReplyToName'=>'ReplyTo Name',
    'ReplyToEmail'=>'ReplyTo Email',
    'Host'=>'Host',
    'SMTPAuthentication'=>'SMTP Authentication',
    'Encryption'=>'Encryption',
    'Port'=>'Port',
    'Next'=>'Next',
    'NewAssessmentQuestion'=>'New Assessment Question',
    'Question'=>'Question',
    'RiskScore'=>'Risk Score',
    'SubmitRisk'=>'Submit Risk',
    'Answer'=>'Answer',
    'AddQuestion'=>'Add Question',
    'SaveAssessment'=>'Save Assessment',
    'SendAssessment'=>'Send Assessment',
    'DeleteAssessment'=>'Delete Assessment',
    'AssessmentName'=>'Assessment Name',
    'SendTo'=>'Send To',
    'ActiveAssessments'=>'Active Assessments',
    'SentTo'=>'Sent To',
    'From'=>'From',
    'Key'=>'Key',
    'GoToSSOLoginPage'=>'Go to SSO Login Page',
    'APIKey'=>'API Key',
    'GenerateAPIKey'=>'Generate API Key',
    'RotateAPIKey'=>'Rotate API Key',
    'InvalidateAPIKey'=>'Invalidate API Key',
    'Deactivate'=>'Deactivate',
    'ImportExportExtra'=>'Import-Export Extra',
    'SaveDetails'=>'Save Details',
    'ClearForm'=>'Clear Form',
    'SaveMitigation'=>'Save Mitigation',
    'Cancel'=>'Cancel',
    'SubmitReview'=>'Submit Review',
    'UnassignedRisks'=>'Unassigned Risks',
    'DisableRegistrationNotice'=>'Disable Registration Notice',
    'UserPolicy'=>'User Policy',
    'UseCaseSensitiveValidationOfUsername'=>'Use Case Sensitive Validation of Username',
    'MitigationPlanning'=>'Planned Mitigation Date',
    'AssetDetails'=>'Asset Details',
    'RiskList'=>'Risk List',
    'Are you sure you want to close the risk? All changes will be lost!'=>'Are you sure you want to close the risk? All changes will be lost!',
    'MinimumPasswordAge' => 'Minimum Password Age',
    'MaximumPasswordAge' => 'Maximum Password Age',
    'MaximumAttemptsLockout' => 'Maximum Attempts Lockout',
    'MaximumAttemptsLockoutTime' => 'Maximum Attempts Lockout Time',
    'attempts' => 'attempts',
    'minutes' => 'minutes',
    'minute' => 'minute',
    'AccountLockedOut' => 'Account Locked Out',
    'AccountLockoutPolicy' => 'Account Lockout Policy',
    'ImportExportIsDeactivated' => 'Import-export is deactivated',
    'PurchaseTheExtra' => 'Purchase the Extra',
    'ExpandAll' => 'Expand All',
    'ConditionMessageForMinChar' => 'Password should contain the minimum of $min_chars characters.',
    'ConditionMessageForAlpha' => 'Password should contain an alpha character.',
    'ConditionMessageForUppercase' => 'Password should contain an uppercase character.',
    'ConditionMessageForLowercase' => 'Password should contain a lowercase character.',
    'ConditionMessageForDigit' => 'Password should contain a digit.',
    'ConditionMessageForSpecialchar' => 'Password should contain a special character.',
    'ConditionMessageForMinPasswordAge' => 'Password can be updated from last updated time the minimum of $min_password_age days later .',
    'TrustedDomains' => 'Trusted Domains',
    'SimpleRiskColumnMapping' => 'SimpleRisk Column Mapping',
    'Mapping' => 'Mapping',
    'Optional' => 'Optional',
    'SaveMappingAs' => 'Save Mapping As',
    'EncryptionLevel' => 'Encryption Level',
    'Level' => 'Level',
    'Description' => 'Description',
    'ShowRiskScoreOverTime' => 'Show Risk Score Over Time',
    'HideRiskScoreOverTime' => 'Hide Risk Score Over Time',
    'ReviewRegularlyHelp' => 'Below is the list of all risks sorted by Unreviewed, Past Due, and Next Review Date',
    'RiskScoringHistory' => 'Risk Scoring History',
    'RiskAddPermissionMessage' => 'You do not have permission to submit new risks.  Any risks that you attempt to submit will not be recorded.  Please contact an Administrator if you feel that you have received this message in error.',
    'SubjectRiskCannotBeEmpty' => 'The subject of a risk cannot be empty',
    'InvalidRiskID' => 'Invalid Risk ID',
    'Success' => 'Success',
    'RiskUpdatePermissionMessage' => 'You do not have permission to modify risks.  Any risks that you attempt to modify will not be recorded.  Please contact an Administrator if you feel that you have received this message in error.',
    'RiskReviewPermission' => 'You do not have permission to review $risk_level level risks.  Any reviews that you attempt to submit will not be recorded.  Please contact an administrator if you feel that you have received this message in error.',
    'DateAndTime' => 'Date and time',
    'mCryptWarning' => 'The "mcrypt" extension needs to be installed for the Encryption Extra to work properly.  Please install it to continue.',
    'APIInCompatibleWithEncryptionLevel' => 'The API is not compatible with the user encryption level of the Encrypted Database Extra.',
    'UnauthenticatedAccessInAPI' => 'Unauthenticated Access.  Please log in or provide a key to use the SimpleRisk API.',
    'ResetPasswordMessageInUserLevelEncryption' => 'You can not reset the password because this user is in user-level encryption. Please contact administrator.',
    'YouNeedToSpecifyAnIdParameter' => 'You need to specify an id parameter.',
    'NoMitigation' => 'There is no specified mitigation.',
    'NoReview' => 'There is no specified review.',
    'MysqldumpPathWasSavedSuccessfully' => 'Mysqldump path was saved successfully.',
    'UnavailableMysqldumpService' => 'There is no avaiable `mysqldump` service on server. Please set absolute mysqldump service path.',
    'AllOpenRisksByTeamByLevel' => 'All Open Risks by Team by Risk Level',
    'Unknown' => 'Unknown',
    'AllOwners' =>'All Owners',
    'AllOwnersManagers' => 'All Owner\'s Managers',
    'AddNewReviewNamed' => 'Add new review named',
    'DeleteCurrentReviewNamed' => 'Delete current review named',
    'AddNewNextstepNamed' => 'Add new next step',
    'DeleteCurrentNextstepNamed' => 'Delete current next step named',
    'Settings' => 'Settings',
    'EnablePopupWindowsForTextBoxes' => 'Enable pop-up windows for text boxes',
    'PasswordNoLongerUse' => 'Password history is enabled and this password has already been used. Please try another password.',
    'RememberTheLast' => 'Remember The Last',
    'Passwords' => 'Passwords',
    'NoOwner' => 'No Owner',
    'NoOwnersManager' => 'No Owners Manager',
    'RiskAverageOverTime' => 'Risk Average Over Time',
    'AverageRiskScore' => 'Average Risk Score',
    'Year' => 'Year',
    'Month' => 'Month',
    'Day' => 'Day',
    'FilterByAffectedAsset' => 'Filter by Affected Asset',
    'RisksOpened' => 'Risks Opened',
    'RisksClosed' => 'Risks Closed',
    'HealthCheck' => 'Health Check',
    'RequirePasswordChangeOnLogin' => 'Require password change on login',
    'PasswordChangeRequired' => 'You need to change your password before login.',
    'LikelihoodImpact' => 'Likelihood and Impact',
    'MitigationPercent' => 'Mitigation Percent',
    'MitigationPermissionMessage' => 'You do not have permission to plan mitigations.  Any mitigations that you attempt to submit will not be recorded.  Please contact an Administrator if you feel that you have received this message in error.',
    'ResetCustomDisplaySettings' => 'Reset Custom Display Settings',
    'CustomResetSuccessMessage' => 'Your custom display settings was reset successfully',
    'DefaultRiskScore' => 'Default Risk Score',
    'AdditionalStakeholders' => 'Additional Stakeholders',
    'AllStakeholders' => 'All Stakeholders',
    'RiskIdDoesNotExist' => 'Risk ID Does Not Exist',
    'RiskDisplayPermission' => 'You have no permission to see this risk. Please contact server manager.',
    'AllowOwnerToSeeRiskDetails' => 'Allow Owner to See Risk Details',
    'AllowOwnerManagerToSeeRiskDetails' => 'Allow Owner\'s Manager to See Risk Details',
    'AllowRiskSubmitterToSeeRiskDetails' => 'Allow Risk Submitter to See Risk Details',
    'AllowTeamMembersToSeeRiskDetails' => 'Allow Team Members to See Risk Details',
    'AllowAdditionalStakeholdersToSeeRiskDetails' => 'Allow Additional Stakeholders to See Risk Details',
    'SavedSuccess' => 'Successfully saved.',
    'DeletedMappingSuccess' => 'Successfully deleted a mapping.',
    'SelectMappingToRemove' => 'Please select a mapping to remove.',
    'Schedule' => 'Schedule',
    'Daily' => 'Daily',
    'Weekly' => 'Weekly',
    'Monthly' => 'Monthly',
    'Quarterly' => 'Quarterly',
    'Annually' => 'Annually',
    'SpecifiedTime' => 'Specified Time',
    'Governance' => 'Governance',
    'Compliance' => 'Compliance',
    'AllowAccessToRiskManagementMenu' => 'Allow Access to "Risk Management" Menu',
    'CheckAllGovernance' => 'Check All Governance',
    'CheckAllCompliance' => 'Check All Compliance',
    'AllowAccessToGovernanceMenu' => 'Allow Access to "Governance" Menu',
    'AllowAccessToComplianceMenu' => 'Allow Access to "Compliance" Menu',
    'DefineControlFrameworks' => 'Define Control Frameworks',
    'NewFramework' => 'New Framework',
    'EditFramework' => 'Edit Framework',
    'CurrentProjects' => 'Current Projects',
    'Frameworks' => 'Frameworks',
    'Controls' => 'Controls',
    'NewControl' => 'New Control',
    'EditControl' => 'Edit Control',
    'CanceledProjects' => 'Canceled Projects',
    'Priority' => 'Priority',
    'ProjectName' => 'Project Name',
    'ActiveFrameworks' => 'Active Frameworks',
    'InactiveFrameworks' => 'Inactive Frameworks',
    'NewProjectName' => 'New Project Name',
    'NewFrameworkName' => 'New Framework Name',
    'NewFrameworkDescription' => 'New Framework Description',
    'AreYouSureYouWantToDeleteThisProject' => 'Are you sure you want to delete this project?',
    'AreYouSureYouWantToDeleteThisFramework' => 'Are you sure you want to delete this framework?',
    'ViewRisks' => 'View Risks',
    'ViewRisk' => 'View Risk',
    'FrameworkName' => 'Framework Name',
    'FrameworkDescription' => 'Framework Description',
    'ImportAssessments' => 'Import Assessments',
    'ExportAssessment' => 'Export Assessment',
    'AssessmentSuccessImport' => 'Successfully imported assessments',
    'AssessmentFileRequired' => 'Assessment CSV File is required',
    'FrameworkUpdated' => 'A framework was updated successfully.',
    'UpdateAll' => 'Update All',
    'SelectAssessmentToExport' => 'Select an assessment to export.',
    'PageTemplates' => 'Page Templates',
    'CustomFields' => 'Custom Fields',
    'AddACustomField' => 'Add a Custom Field',
    'FieldName' => 'Field Name',
    'FieldType' => 'Field Type',
    'CustomFieldNameNotEmpty' => 'The name of a custom field cannot be empty.',
    'DeletedSuccess' => 'Successfully deleted',
    'ActiveControls' => 'Active Controls',
    'ControlName' => 'Control Name',
    'ControlShortName' => 'Control Short Name',
    'ControlLongName' => 'Control Long Name',
    'ControlDescription' => 'Control Description',
    'SupplementalGuidance' => 'Supplemental Guidance',
    'ControlFramework' => 'Control Framework',
    'ControlFrameworks' => 'Control Frameworks',
    'ControlOwner' => 'Control Owner',
    'ControlClass' => 'Control Class',
    'ControlPhase' => 'Control Phase',
    'ControlPriority' => 'Control Priority',
    'ControlFamily' => 'Control Family',
    'AllFrameworks'=>'All Frameworks',
    'NewControlName' => 'New Control Name',
    'NewControlDescription' => 'New Control Description',
    'AreYouSureYouWantToDeleteThisControl' => 'Are you sure you want to delete this control?',
    'AddNewControlClassNamed' => 'Add new control class named',
    'DeleteCurrentControlClassNamed' => 'Delete current control class named',
    'AddNewControlPhaseNamed' => 'Add new control phase named',
    'DeleteCurrentControlPhaseNamed' => 'Delete current control phase named',
    'AddNewControlPriorityNamed' => 'Add new control priority named',
    'DeleteCurrentControlPriorityNamed' => 'Delete current control priority named',
    'AddNewControlFamilyNamed' => 'Add new control family named',
    'DeleteCurrentControlFamilyNamed' => 'Delete current control family named',
    'MinutesAssessmentsAreValid' => 'Minutes Assessments Are Valid',
    'ShowAvailableAssetsOnAssessments' => 'Show available assets on assessments',
    'AssessmentSettingsUpdatedSuccessfully' => 'Assessment settings were updated successfully.',
    'UseCommasToSeperateMultipleEmails' => 'Use commas to seperate multiple emails.',
    'RiskAssessmentQuestionnaire' => 'Risk Assessment Questionnaire',
    'EmailTemplateSendingAssessment' => '
        <html><body>
            Hello,
            <p> {$username} has asked you to complete the following risk assessment questionnaire:</p>
            <p><a href="{$assessment_link}"> {$assessment_name} </a></p>
            <p>This is an automated message and responses will be ignored or rejected.</p>
        </body></html>',
    'FilterByText' => 'Filter by Text',
    'SelectMitigatingControls' => 'Select Mitigating Control(s)',
    'MitigationControls' => 'Mitigation Controls',
    'EnableTLSEncryptionAutomaticallyIfAServerSupportsIt' => 'Enable TLS encryption automatically if a server supports it',
    'AssessmentContacts' => 'Assessment Contacts',
    'Name' => 'Name',
    'ContactManager' => 'Contact Manager',
    'AddNewAssessmentContact' => 'Add a New Assessment Contact',
    'UpdateAssessmentContact' => 'Update an Assessment Contact',
    'AssessmentContactCreated' => 'A new assessment contact was created',
    'AssessmentContactUpdated' => 'An assessment contact was updated',
    'InvalidInformations' => 'Invalid Informations',
    'AreYouSureYouWantToDeleteThisContact' => 'Are you sure you want to delete this contact?',
    'ImportAssessmentContacts' => 'Import Assessment Contacts',
    'ImportCsvXlsFile' => 'Import the following CSV or XLS file into SimpleRisk',
    'AssessmentContactsImported' => 'The assessment contacts imported',
    'DefineTests' => 'Define Tests',
    'AddTest' => 'Add Test',
    'Tester' => 'Tester',
    'TestFrequency' => 'Test Frequency',
    'Objective' => 'Objective',
    'TestSteps' => 'Test Steps',
    'LastTestDate' => 'Last Test Date',
    'NextTestDate' => 'Next Test Date',
    'ApproximateTime' => 'Approximate Time',
    'ExpectedResults' => 'Expected Results',
    'ControlID' => 'Control ID',
    'TestSuccessCreated' => 'A test was successfully created.',
    'TestSuccessUpdated' => 'A test was successfully updated.',
    'QuestionnaireQuestions' => 'Questionnaire Questions',
    'AreYouSureYouWantToDeleteThisQuestion' => 'Are you sure you want to delete this question?',
    'NewQuestionnaireQuestion' => 'New Questionnaire Question',
    'EditQuestionnaireQuestion' => 'Edit Questionnaire Question',
    'Answers' => 'Answers',
    'InvalidQuestionOrAnswers' => 'Invalid Question or Answers.',
    'SuccessTestDeleted'=>'Test Deleted Successfully',
    'AreYouSureYouWantToDeleteThisTest'=>'Are you sure you want to delete this test?',
    'ImportAssessmentQuestionnaireQuestions'=>'Import Assessment Questionnaire Questions',
    'QuestionAndAnswersRquired'=>'Question and Answers are required.',
    'AssessmentQuestionnaireQuestionsAndAnwersImported'=>'Assessment questionnaire questions and answers are imported successfully.',
    'QuestionnaireTemplates'=>'Questionnaire Templates',
    'AreYouSureYouWantToDeleteThisTemplate'=>'Are you sure you want to delete this template?',
    'NewQuestionnaireTemplate'=>'New Questionnaire Template',
    'Questions'=>'Questions',
    'TemplateNameRequired'=>'Template name is required.',
    'EditQuestionnaireTemplate'=>'Edit Questionnaire Template',
    'InitiateAudits'=>'Initiate Audits',
    'TestName'=>'Test Name',
    'ParentFramework'=>'Parent Framework',
    'LastAuditDate'=>'Last Audit Date',
    'NextAuditDate'=>'Next Audit Date',
    'DesiredFrequency'=>'Desired Frequency',
    'Framework'=>'Framework',
    'Control'=>'Control',
    'Test'=>'Test',
    'Active'=>'Active',
    'Inactive'=>'Inactive',
    'InitiateFrameworkAudit'=>'Initiate Framework Audit',
    'InitiateControlAudit'=>'Initiate Control Audit',
    'InitiateTest'=>'Initiate Test',
    'Questionnaires'=>'Questionnaires',
    'AreYouSureYouWantToDeleteThisQestionnaire' => 'Are you sure you want to delete this questionnaire?',
    'NewQuestionnaire'=>'New Questionnaire',
    'EditQuestionnaire'=>'Edit Questionnaire',
    'Template'=>'Template',
    'Save'=>'Save',
    'DuplicatedQuestionnaireName'=>'Duplicated Questionnaire Name.',
    'QuestionnaireNameRequired'=>'Questionnaire name is required.',
    'InitiatedAllTestsUnderFramework'=>'Initiated all tests under a Framework, $framework.',
    'InitiatedAllTestsUnderControl'=>'Initiated all tests under a Control, $control.',
    'InitiatedTest'=>'Initiated a test, $test.',
    'SentQuestionnaire'=>'Sent a questionnaire to each contacts successfully.',
    'SetPassword'=>'Set password',
    'NoMatchPassword'=>'The passwords should match.',
    'SetPasswordSuccess'=>'Password was set successfully.',
    'InvalidPassword'=>'Invalid password',
    'InvalidTokenForQuestionnaire'=>'You need a valid token in order to display a questionnaire.',
    'RequiredTokenForQuestionnaire'=>'You need to send a token in order to display the questionnaire.',
    'NoPermissionForQuestionnaire'=>'You don\'t have permission this questionnaire.',
    'NoPermissionForTemplate'=>'You don\'t have permission this template.',
    'RunNow'=>'Run Now',
    'ActiveAudits'=>'Active Audits',
    'Questionnaire'=>'Questionnaire',
    'Draft'=>'Draft',
    'Complete'=>'Complete',
    'AdditionalInformation'=>'Additional Information',
    'Clear'=>'Clear',
    'PendingEvidenceFromControlOwner'=>'Pending Evidence from Control Owner',
    'EvidenceSubmittedPendingReview'=>'Evidence Submitted / Pending Review',
    'PassedInternalQA'=>'Passed Internal QA',
    'RemediationRequired'=>'Remediation Required',
    'Closed'=>'Closed',
    'TestResult'=>'Test Result',
    'Summary'=>'Summary',
    'TestDate'=>'Test Date',
    'Attachment'=>'Attachment',
    'InvalidParams'=>'Invalid params',
    'ClearForm'=>'Clear Form',
    'QuestionnaireDraftSuccess'=>'Your answers were successfully saved.',
    'QuestionnaireCompletedSuccess'=>'You completed this questionnaire successfully.',
    'EmailTemplateCompleteQuestionnaire' => '
        <html><body>
            Hello,
            <p> {$conact_name} completed a questionnaire, <b>{$questionnaire_name}</b></p>
            <p>This is an automated message and responses will be ignored or rejected.</p>
        </body></html>',
    'QuestionnaireResults'=>'Questionnaire Results',
    'DateSent'=>'Date Sent',
    'Contact'=>'Contact',
    'PercentCompleted'=>'Percent Completed',
    'Incomplete'=>'Incomplete',
    'Completed'=>'Completed',
    'QuestionnaireName'=>'Questionnaire Name',
    'QuestionnaireHasNoContacts'=>'This questionnaire has nothing contacts, so couldn\'t send.',
    'FrameworkAdded'=>'A new framework was added successfully.',
    'FrameworkNameExist'=>'The framework name already exists.',
    'FrameworkNameCantBeEmpty'=>'The framework name can\'t be empty.',
    'FrameworkCantBeItsOwnParent'=>'The framework can\'t be its own parent.',
    'FrameworkParentUpdated'=>'The framework\'s parent successfully updated.',
    'AttachmentFiles'=>'Attachment Files',
    'QuestionnaireFiles'=>'Questionnaire Files',
    'ContactEmailAlreadyInUse'=>'The contact email is already in use.',
    'InherentRisk'=>'Inherent Risk',
    'ResidualRisk'=>'Residual Risk',
    'PastAudits'=>'Past Audits',
    'AuditDate'=>'Audit Date',
    'Reopen'=>'Reopen',
    'CreatedDate'=>'Created Date',
    'QuestionnaireAuditTrail'=>'Questionnaire Audit Trail',
    'SelectYourControlFrameworks'=>'Select Your Control Frameworks',
    'QuestionnaireAlreadySent'=>'This questionnaire was already sent, so you can not update this questionnaire.',
    'SelectAll' => 'Select All',
    'TestStatus' => 'Test Status',
    'DeleteCurrentStatusNamed' => 'Delete Current Status Named',
    'AuditStatus' => 'Audit Status',
    'TheClosedStatusCantBeDeleted' => 'The Closed status can\'t be deleted.',
    'AuditStatusDeleted' => 'An audit status was removed successfully.',
    'HasFile' => 'Has File',
    'ClosedAuditStatus' => 'Closed Audit Status',
    'ClosedAuditStatusIsRequired' => 'Closed Audit Status is required',
    'UserInterface' => 'User Interface',
    'DefaultLanguage' => 'Default Language',
    'DefaultTimezone' => 'Default Timezone',
    'UserSessions' => 'User Sessions',
    'SessionActivityTimeout' => 'Session Activity Timeout',
    'Security' => 'Security',
    'EnableCSP' => 'Enable Content Security Policy (This has broken Chrome in the past)',
    'EnableDebugLogging' => 'Enable Debug Logging',
    'seconds' => 'seconds',
    'FieldSample' => 'Field Sample',
    'StartDate' => 'Start Date',
    'EndDate' => 'End Date',
    'DefaultClosedAuditStatus' => 'Default Closed Audit Status',
    'AutomatedNotificationsOfUnreviewedPastDueRisks' => 'Automated Notifications of Unreviewed / Past Due Risks',
    'SimpleRiskActionNotifications' => 'SimpleRisk Action Notifications',
    'WhenToNotify' => 'When To Notify',
    'WhoToNotify' => 'Who To Notify',
    'HowToNotify' => 'How To Notify',
    'NotifyOnNewRisk' => 'Notify on New Risk',
    'NotifyOnRiskUpdate' => 'Notify on Risk Update',
    'NotifyOnNewMitigation' => 'Notify on New Mitigation',
    'NotifyOnMitigationUpdate' => 'Notify on Mitigation Update',
    'NotifyOnRiskReview' => 'Notify on Risk Review',
    'NotifyOnRiskClose' => 'Notify on Risk Close',
    'NotifyOnRiskComment' => 'Notify on Risk Comment',
    'NotifySubmitter' => 'Notify Submitter',
    'NotifyOwner' => 'Notify Owner',
    'NotifyOwnersManager' => 'Notify Owner\'s Manager',
    'NotifyTeam' => 'Notify Team',
    'NotifyAdditionalStakeholders' => 'Notify Additional Stakeholders',
    'NotifyReviewers' => 'Notify Reviewers',
    'NotifyTester' => 'Notify Tester',
    'SimpleRiskURL' => 'SimpleRisk URL',
    'Period' => 'Period',
    'PlaceTheFollowingInYourCrontabToRunAutomatically' => 'Place the following in your crontab to run automatically',
    'SimpleRiskScheduledNotifications' => 'SimpleRisk Scheduled Notifications',
    'AutomatedNotificationsOfAudits' => 'Automated Notifications of Audits',
    'SendAnEmail' => 'Send an email',
    'SendAnEmailEvery' => 'Send an email every',
    'DaysBeforeTheAuditIsDue' => 'days before the audit is due',
    'DaysAfterTheAuditIsDue' => 'days after the audit is due',
    'SendAnEmailWhenTheAuditIsDue' => 'Send an email when the audit is due',
    'PendingRiskDeleted' => 'The pending risk was deleted successfully',
    'RunAt' => 'Run At',
    'ImportControls' => 'Import Controls',
    'RiskIDNoEXitFailedToUpdate' => 'Risk ID $risk_id doesn\'t exist, so it is has not been imported or updated',
    'CreatedRisksFromPendingRisks' => 'Created all risks from pending risks.',
    'AddAll' => 'Add All',
    'SendingPleaseWait' => 'Sending... Please wait.',
    'SelectForMitigationControls' => 'Select for Mitigation Controls',
    'QuestionnaireTemplateName' => 'Questionnaire Template Name',
    'Ordering' => 'Ordering',
    'AuditsDueToday' => 'Audits Due Today',
    'AuditsPastDue' => 'Audits Past Due',
    'AuditsDueSoon' => 'Audits Due Soon',
    'DateDue' => 'Date Due',
    'ShowAllRisksForPlanProjects' => 'Show all risks for planned projects instead of only those reviewed as "Consider for Project"',
    'Edit' => 'Edit',
    'Clone' => 'Clone',
    'SubQuestions' => 'Sub Questions',
    'Ordering' => 'Ordering',
    'EncryptionKeyNoExist' => 'Encryption Key file doesn\'t exist. Please contact admin.',
    'ResidualRiskScore' => 'Residual Risk Score',
    'DefaultInitiatedAuditStatus' => 'Default Initiated Audit Status',
    'ImportAssessmentQuestionnaireTemplates' => 'Import Assessment Questionnaire Templates',
    'QuestionnaireTemplateColumnMapping' => 'Questionnaire Template Column Mapping',
    'QuestionnaireTemplatesImported' => 'Questionnaire Templates are imported successfully.',
    'ExportQuestionnaireTemplate' => 'Export Questionnaire Template',
    'DeleteAll' => 'Delete All',
    'AreYouSureToDeleteAllPendingRisks' => 'Are you sure to delete all pending risks?',
    'AllPendingRisksDeleted' => 'All pending risks were deleted successfully',
    'CompareResults' => 'Compare Results',
    'Compare' => 'Compare',
    'SelectQuestionnairesCompare' => 'Please select questionnaires to be compared',
    'TemplatesAreRequired' => 'Templates must be defined',
    'AssetRisk' => 'Asset Risk',
    'DefaultDateFormat' => 'Default Date Format',
    'Role' => 'Role',
    'RoleManagement' => 'Role Management',
    'AddNewRole' => 'Add a New Role',
    'RoleName' => 'Role Name',
    'AddedSuccess' => 'Successfully added.',
    'CantDeleteAdministratorRole' => 'Administrator Role can not be deleted.',
    'GoToSSOLogin' => 'Show the "Go to SSO Login Page" link on the main login page',
    'SSOLoginDisabled' => 'SSO Login was disabled, so you can\'t use this authentication.',
    'QuestionID' => 'Question ID',
    'QuestionOrdering' => 'Question Ordering',
    'DefaultUserRole' => 'Default User Role',
    'AbleToAcceptMitigations' => 'Able to Accept Mitigations',
    'AcceptMitigation' => 'Accept Mitigation',
    'RejectMitigation' => 'Reject Mitigation',
    'MitigationAcceptedByUserOnTime' => 'Mitigation accepted by {$name} on {$date} at {$time}',
    'TestMailSettings' => 'Test Mail Settings',
    'OptionName' => 'Option Name',
    'OptionNameNotEmpty' => 'The name of a custom option cannot be empty.',
    'QueryOnlyAvailableToAdminUsers' => 'Query only available to admin users.',
    'CustomFieldCreatedSuccess' => 'Custom field named "{$name}" created successfully!',
    'CustomOptionAddedSuccess' => 'Custom option named "{$name}" added successfully!',
    'SelectOptionsToDelete' => 'Please select options to delete.',
    'CustomFieldDeletedSuccess' => 'Custom field has been deleted successfully.',
    'CustomFieldDeletedFailed' => 'Failed to delete custom field.',
    'RiskSubmitSuccess' => 'Risk "{$subject}" has been submitted successfully.',
    'Accepting' => 'Accepting...',
    'Rejecting' => 'Rejecting...',
    'CustomizationExtra' => 'Customization Extra',
    'AddMainField' => 'Add Main Field',
    'MainField' => 'Main Field',
    'AddCustomField' => 'Add Custom Field',
    'CustomField' => 'Custom Field',
    'SuccessTemplateSaved' => 'Template was saved successfully.',
    'AbleToAddNewFrameworks' => 'Able to Add New Frameworks',
    'AbleToModifyExistingFrameworks' => 'Able to Modify Existing Frameworks',
    'AbleToDeleteExistingFrameworks' => 'Able to Delete Existing Frameworks',
    'AbleToAddNewControls' => 'Able to Add New Controls',
    'AbleToModifyExistingControls' => 'Able to Modify Existing Controls',
    'AbleToDeleteExistingControls' => 'Able to Delete Existing Controls',
    'NoAddFrameworkPermission' => 'You have no permission to add frameworks.',
    'NoModifyFrameworkPermission' => 'You have no permission to modify frameworks.',
    'NoDeleteFrameworkPermission' => 'You have no permission to delete frameworks.',
    'FrameworkStatusSuccessUpdate' => 'The framework statuses were successfully updated.',
    'NoAddControlPermission' => 'You have no permission to add controls.',
    'NoModifyControlPermission' => 'You have no permission to modify controls.',
    'NoDeleteControlPermission' => 'You have no permission to delete controls.',
    'WarnPHPUploadSize' => 'Warning: the current file size limit is larger than PHP allows to be uploaded. Check the upload_max_filesize, post_max_size, and memory_limit values in your php.ini file.',
    'WarnMySQLUploadSize' => 'Warning: the current file size limit is larger than MySQL is configured for uploads.  Check the max_allowed_packet and innodb_log_file_size values in your my.cnf file.',
    'Restore' => 'Restore',
    'MitigationSupportingDocumentation' => 'Mitigation Supporting Documentation',
    'SetNextReviewDate' => 'Set Next Review Date',
    'MitigationControlsList' => 'Mitigation Control List',
    'NextReviewDateUses' => 'Next Review Date Uses',
    'AdminPermissionRequired' => 'Admin permission is required.',
    'AddImpact' => 'Add impact',
    'DeleteImpact' => 'Delete impact',
    'AddLikelihood' => 'Add likelihood',
    'DeleteLikelihood' => 'Delete likelihood',
    'SuccessAddingImpact' => 'Success to add an impact',
    'SuccessDeletingImpact' => 'Success to delete an impact',
    'FailAddingImpact' => 'Failure to add an impact',
    'FailDeletingImpact' => 'Failure to delete an impact',
    'SuccessAddingLikelihood' => 'Success to add a likelihood',
    'SuccessDeletingLikelihood' => 'Success to delete a likelihood',
    'FailAddingLikelihood' => 'Failure to add a likelihood',
    'FailDeletingLikelihood' => 'Failure to delete a likelihood',
    'SubjectRequired' => 'Subject is required. Please select the field.',
    'Spreadsheet' => 'Spreadsheet',
    'SuccessUpdatingImpactName' => 'The impact name was updated successfully.',
    'FailUpdatingImpactName' => 'Failure to update impact name.',
    'SuccessUpdatingLikelihoodName' => 'The likelihood name was updated successfully.',
    'FailUpdatingLikelihoodName' => 'Failure to update likelihood name.',
    'DocumentProgram' => 'Document Program',
    'AbleToAddDocumentation' => 'Able to Add Documentation',
    'AbleToModifyDocumentation' => 'Able to Modify Documentation',
    'AbleToDeleteDocumentation' => 'Able to Delete Documentation',
    'DuplicatedOptionName' => 'Duplicated option name.',
    'DocumentHierarchy' => 'Document Hierarchy',
    'Policies' => 'Policies',
    'Guidelines' => 'Guidelines',
    'Standards' => 'Standards',
    'Procedures' => 'Procedures',
    'General' => 'General',
    'FileUpload' => 'File Upload',
    'Mail' => 'Mail',
    'DocumentType' => 'Document Type',
    'DocumentName' => 'Document Name',
    'CreationDate' => 'Creation Date',
    'ParentDocument' => 'Parent Document',
    'InReview' => 'In Review',
    'Approved' => 'Approved',
    'File' => 'File',
    'DocumentAdded'=>'A new document was added successfully.',
    'DocumentDeleted'=>'A new document was deleted successfully.',
    'DocumentNameExist'=>'The document name already exists.',
    'NoAddDocumentationPermission' => 'You have no permission to add documents.',
    'NoModifyDocumentationPermission' => 'You have no permission to modify documents.',
    'NoDeleteDocumentationPermission' => 'You have no permission to delete documents.',
    'AreYouSureYouWantToDeleteThisDocument' => 'Are you sure you want to delete this document?',
    'AutomatedNotificationOfPlannedMitigations' => 'Automated Notification of Planned Mitigations',
    'DaysBeforeTheMitigationIsDue' => 'days before the mitigation is due',
    'DaysAfterTheMitigationIsDue' => 'days after the mitigation is due',
    'SendAnEmailWhenTheMitigationIsDue' => 'Send an email when the mitigation is due',
    'NotifyMitigationOwner' => 'Notify Mitigation Owner',
    'NotifyMitigationTeam' => 'Notify Mitigation Team',
    'NotifyRiskSubmitter' => 'Notify Risk Submitter',
    'NotifyRiskOwner' => 'Notify Risk Owner',
    'NotifyRiskOwnersManager' => 'Notify Risk Owner\'s Manager',
    'NotifyRiskTeam' => 'Notify Risk Team',
    'NotifyRiskAdditionalStakeholders' => 'Notify Risk Additional Stakeholders',
    'MitigationsDueToday' => 'Mitigations Due Today',
    'MitigationsPastDue' => 'Mitigations Past Due',
    'MitigationsDueSoon' => 'Mitigations Due Soon In {$DueDate} days',
    'MitigationsNotificationEmailTitle' => 'You are receiving this message because you are the submitter, owner, owner\'s manager, belong to the team, or are an additional stakeholder associated with the following risks which are due for mitigation.  You will continue to receive e-mail reminders until the risk has been closed or the mitigation date has been updated.',
    'RisksAndControls'=>'Risks and Controls',
    'ControlsByRisk' =>'Controls by Risk',
    'RisksByControl' =>'Risks by Control',
    'ViewControlDetails' => 'View Control Details',
    'HideControlDetails' => 'Hide Control Details',
    'YouNeedToUpgradeYourSimpleRiskSubscription' => 'You need to upgrade your SimpleRisk subscription to enable use of this Extra.',
    'AutomaticallyAddNewlyAuthenticatedUsersWithDefaultRole' => 'Automatically add newly authenticated users with the default role',
    'Disabled' => 'Disabled',
    'AbleToCommentRiskManagement' => 'Able to Comment Risk Management',
    'AbleToCommentCompliance' => 'Able to Comment Compliance',
    'LanguageUpdated' => 'Your language was updated successfully.',
    'SelectValidLanguage' => 'You need to select a valid language',
    'PasswordUpdated' => 'Your password has been updated successfully!',
    'PasswordIncorrect' => 'You have entered your current password incorrectly. Please try again.',
    'RiskFormRemark' => 'Complete the form above to document a risk for consideration in Risk Management Process',
    'PasswordRequirements' => 'Password should have the following requirements.',
    'NoDataAvailable' => 'No Data Available',
    'ChooseFile' => 'Choose File',
    'FileAdded' => 'File Added',
    'IPFormatNotRecognized' => 'IP was not in a recognizable format.',
    'Open' => 'Open',
    'Mitigated' => 'Mitigated',
    'Unmitigated' => 'Unmitigated',
    'Reviewed' => 'Reviewed',
    'Unreviewed' => 'Unreviewed',
    'NewRiskInstruction' => 'Complete the form above to document a risk for consideration in Risk Management Process',
    'New' => 'New',
    'ManagementReviewed' => 'Mgmt Reviewed',
    'Reopened' => 'Reopened',
    'Treated' => 'Treated',
    'Untreated' => 'Untreated',
    'passwords' => [
        'user' => 'Unknown User'
    ],
    'NewRisk' => 'New Risk',
    'AddLdapGroup' => 'Add a LDAP Group',
    'GroupName' => 'Group Name',
    'LdapGroup' => 'LDAP GROUP',
    'SuccessDeleteLdapGroup' => 'Successfully deleted LDAP group',
    'LDAPGroupNameExists' => 'The LDAP Group name already exists',
    'SetTeams' => 'Set Teams',
    'MappedControls' => 'Mapped Controls',
    'WithExtension' => 'with extension',
    'DeleteCurrentExtensionOf' => 'Delete current extension of',
    'FailedInitiate' => 'Failed to initiate.',
    'NoPermissionForCompliance' => 'You don\'t have permission to view compliance.',
    'NoPermissionForGovernance' => 'You don\'t have permission to view governance.',
    'FailedToUploadFile' => 'Failed to upload file',
    'NewPasswordDoesNotMatchPolicy' => 'The new password specified does not adhere to the configured password policy.',
    'RiskLevels' => 'Risk Levels',
    'ClassicRiskFormula' => 'Classic Risk Formula',
    'ContributingRiskFormula' => 'Contributing Risk Formula',
    'ImpactHasMaxChars' => 'Impact should have max $length chars.',
    'LikelihoodHasMaxChars' => 'Likelihood should have max $length chars.',
    'MapTeamAndGroup' => 'Map team and group',
    'ContributionWeight' => 'Contribution Weight',
    'TotalContributingWeightsShouldBe1' => 'Total contributing weights should be equal to 1.',
    'SuccessSaveContributingRisks' => 'Successfully saved contributing risks.',
    'ScoreUsingContributingRisk' => 'Score Using Contributing Risk',
    'ContributingRiskCalendarDescription' => 'This page provides a calculator for creating Contributing Risk vulnerability severity scores.',
    'SimpleriskContributingRiskCalculator' => 'SimpleRisk Contributing Risk Calculator',
    'ContributingRiskScore' => 'Contributing Risk Score',
    'OverallContributingRiskScore' => 'Overall Contributing Risk Score',
    'ContributingRisk' => 'Contributing Risk',
    'Weight' => 'Weight',
    'AllowAllUsersToSeeRisksNotAssignedToTeam' => 'Allow all users to see risks not assigned to a team',
    'ContributingLikelihood' => 'Contributing Likelihood',
    'ContributingSubjectsImpacts' => 'Contributing Subjects and Impacts',
    'ScoreByContributingRisk' => 'Score by Contributing Risk',
    'ContributingRiskScoring' => 'Contributing Risk Scoring',
    'UpdateContributingRiskScore' => 'Update Contributing Risk Score',
    'MaxImpact' => 'Max Impact',
    'MaxLikelihood' => 'Max Likelihood',
    'ExtraName' => 'Extra Name',
    'McryptIsBeingRetired' => 'The mcrypt extension is deprecated and will be removed in PHP 7.2.  Select the button below to convert to using openssl instead.',
    'Convert' => 'Convert',
    'OpensslWarning' => 'The "openssl" extension needs to be installed for the Encryption Extra to work properly.  Please install it to continue.',
    'MapSuccessTeamAndGroup' => 'Successfully mapped team and LDAP group.',
    'MappingTeamAndLDAPGroupRequired' => 'Team and LDAP group for mapping is required.',
    'ExistingMappings' => 'Existing Mappings',
    'TeamGroup' => '(Team <--> Group)',
    'ExistingMappingsRequired' => 'Existing mappings should be selected.',
    'EncryptionBackupFileExists' => 'As part of the encryption process, an unencrypted backup copy of your SimpleRisk database has been created.  Once you have verified everything has encrypted properly, move it to a secure location or click the button to delete it.',
    'BackupLocation' => 'Backup Location',
    'FileDeletedSuccessfully' => 'The file has been deleted successfully.',
    'ErrorDeletingFile' => 'There was an error deleting the file.  Please check the file permissions and try again.',
    'MapToLDAPGroup' => 'Map to LDAP Group',
    'SelectMappingTeam' => 'Please select Team for mapping',
    'UploadingFileTypeNoSupport' => 'The file type of the uploaded file ("{$file_type}") is not supported.',
    'UploadingFileTooBig' => 'The uploaded file was too big.',
    'ImportingFileError' => 'There was an error with the file upload.',
    'NoImportingFile' => 'There was no selected file for importing.',
    'NoPermissionForRiskManagement' => 'You have no permission for risk management.',
    'ErrorAssetAlreadyExists' => 'The asset could not be added because an asset with that name already exists.',
    'RiskSubject' => 'Risk Subject',
    'NotifyOnAuditComment' => 'Notify on Audit Comment',
    'NotifyOnAuditStatusChange' => 'Notify on Audit Status Change',
    'NotifyAuditCommentSubject' => 'Comment Added to Test',
    'NotifyAuditCommentStatement' => 'A new comment has been added to Audit test (ID #{$test_audit_id}) by {$name}.  You are receiving this message because you are listed as either the tester or part of the team associated with the test.',
    'ViewTest' => 'View Test',
    'NotifyAuditStatusChangeSubject' => 'Test Status Changed',
    'NotifyAuditStatusChangeStatement' => 'The Audit test (ID #{$test_audit_id}) status changed by {$name}.  You are receiving this message because you are listed as either the tester or part of the team associated with the test.',
    'OldValue' => 'Old Value',
    'NewValue' => 'New Value',
    'Actions' => 'Actions',
    'Templates' => 'Templates',
    'ComplianceAudit' => 'Compliance Audit',
    'FailControl' => 'Fail Control',
    'Instructions' => 'Instructions',
    'UserInstructions' => 'User Instructions',
    'Verified' => 'Verified',
    'UnverifiedAssets' => 'Unverified Assets',
    'VerifyAll' => 'Verify All',
    'NoPermissionForAsset' => 'You don\'t have permission for Asset Management.',
    'AssetWasVerifiedSuccessfully'=>'Asset was verified successfully.',
    'ThereWasAProblemVerifyingTheAsset'=>'There was a problem verifying the asset.',
    'AutomaticallyVerifyNewAssets' => 'Automatically verify new Assets created through the Asset Selector widget',
    'DiscardAll' => 'Discard All',
    'AssetWasDiscardedSuccessfully' => 'Asset was discarded successfully.',
    'ThereWasAProblemDiscardingTheAsset' => 'There was a problem discarding the asset.',
    'AuditTimeline' => 'Audit Timeline',
    'AssociatedFrameworks' => 'Associated Frameworks',
    'Verify' => 'Verify',
    'Discard' => 'Discard',
    'VerifiedAssets' => 'Verified Assets',
    'FileSize' => 'File Size',
    'FileIsTooBigToUpload' => 'The file is too big to upload.',
    'AssetWasUpdatedSuccessfully' => 'Asset was updated successfully.',
    'ThereWasAProblemUpdatingTheAsset' => 'There was a problem updating the asset.',
    'ImportAssetAddSucceeded' => 'Added "{$verified_or_unverified}" asset named "{$asset_name}" with IP "{$asset_ip}" and value "{$asset_value}".',
    'ImportAssetAddFailed' => 'Failed to add "{$verified_or_unverified}" asset named "{$asset_name}" with IP "{$asset_ip}" and value "{$asset_value}".',
    'NoOperationRequiredOnAsset' => 'No operation required on asset named "{$asset_name}" as it\'s already in the database.',
    'ImportAssetUpdateSucceeded' => 'Updated "{$verified_or_unverified}" asset named "{$asset_name}" with IP "{$asset_ip}" and value "{$asset_value}".',
    'ImportAssetUpdateFailed' => 'Failed to update "{$verified_or_unverified}" asset named "{$asset_name}" with IP "{$asset_ip}" and value "{$asset_value}".',
    'Unverified' => 'Unverified',
    'ExportAssets' => 'Export Assets',
    'ExportToCSVByClickingBelow' => 'Export to a CSV file by clicking below',
    'RevertToUnencryptedBackup' => 'Revert to Unencrypted Backup',
    'SuccessfullyRevertedToUnencryptedBackup' => 'Successfully reverted to unencrypted backup',
    'FailedToRevertToUnencryptedBackup' => 'Failed To Revert to Unencrypted Backup. Please check the server logs for more information.',
    'AddNewItemNamed' => 'Add new item named',
    'DeleteItemNamed' => 'Delete item named',
    'YouNeedToSpecifyANameParameter' => 'You need to specify a name parameter.',
    'ANewItemWasAddedSuccessfully'=>'A new item was added successfully.',
    'AnItemWasUpdatedSuccessfully'=>'An item was updated successfully.',
    'AnItemWasDeletedSuccessfully'=>'An item was deleted successfully.',
    'FailedToAddNewItem' => 'Failed To Add New Item.',
    'FailedToUpdateItem' => 'Failed To Update Item.',
    'FailedToDeleteItem' => 'Failed To Delete Item.',
    'TheEnteredValueIsTooLong' => 'The entered value is too long! Current limit is {$limit} characters.',
    'MissingConfiguration' => 'Missing configuration.',
    'CantDeleteTeamItsInUseByARisk' => 'Cannot delete this team, because there are risks that are currently using it.',
    'UpgradeCustomExtras' => 'Upgrade Custom Extras',
    'DocumentUpdated'=>'A new document was updated successfully.',
    'VerifyOrDiscard' => 'Verify/Discard',
    'RegisterAndUpgrade' => 'Register & Upgrade',
    'ImportExport' => 'Import/Export',
    'Dropdown' => 'Dropdown',
    'MultiDropdown' => 'Multi Dropdown',
    'UserMultiDropdown' => 'User Multi Dropdown',
    'ShortText' => 'Short Text',
    'LongText' => 'Long Text',
    'DateSelector' => 'Date Selector',
    'NotifyControlOwner' => 'Notify Control Owner',
    'PathToPhpExecutable' => '<PATH_TO_YOUR_PHP_EXECUTABLE>',
    'ConfirmDeleteCustomField' => 'Are you sure to delete this custom field?',
    'Integrations' => 'Integrations',
    'FieldGroup' => 'Field Group',
    'Asset' => 'Asset',
    'FailedToRegisterInstance' => 'Failed to register your SimpleRisk instance. Please contact support@simplerisk.com for assistance.',
    'FailedToUpdateInstance' => 'Failed to update your SimpleRisk registration. Please contact support@simplerisk.com for assistance.',
    'FailedToDownloadExtra' => 'Failed to download the requested extra. Please contact support@simplerisk.com for assistance.',
    'RequestedExtraIsNotPurchased' => 'The requested extra is not purchased yet. Please contact support@simplerisk.com for assistance.',
    'RequestedExtraDoesNotExist' => 'The requested extra does not exist. Please contact support@simplerisk.com for assistance.',
    'InstanceWasRegisteredWithDifferentIp' => 'Your SimpleRisk instance was registered with a different IP address. Please contact support@simplerisk.com for assistance.',
    'InstanceIsDisabled' => 'Your SimpleRisk instance is disabled. Please contact support@simplerisk.com for assistance.',
    'InvalidInstanceIdOrKey' => 'Your SimpleRisk instance or key is invalid. Please contact support@simplerisk.com for assistance.',
    'ExtraInstalledSuccessfully' => 'Extra installed successfully.',
    'ImportVulnerabilities' => 'Import Vulnerabilities',
    'ExtraIsAlreadyEnabled' => 'Extra is already enabled.',
    'ExtraIsAlreadyDisabled' => 'Extra is already disabled.',
    'FixReviewDates' => 'Fix Review Dates',
    'SuspectedDateFormat' => 'Suspected Date Format',
    'Confirm' => 'Confirm',
    'ConfirmAll' => 'Confirm All',
    'YouNeedToSpecifyTheFormatParameter' => 'Please select the date format the "Next Review Date" is in.',
    'NextReviewDateWasUpdatedSuccessfully' => 'Next Review Date Was Updated Successfully',
    'NextReviewDateUpdateFailed' => 'Failed to update Next Review Date',
    'PleaseSelect' => 'Please Select',
    'NextReviewMassUpdateInfo' => 'You have dates that could be in either {$format1} or {$format2} format. Treat them as',
    'NextReviewDateFixDisclaimer' => 'We have detected a possible issue with the date formats stored in your SimpleRisk database.  The table below will show you which risks have an invalid date format and need to be corrected. Please take a look at the suspected date format, confirm that it is correct, and then click "Confirm" to have it updated in the database.',
    'NextReviewMassUpdateSuccess' => 'Successfully updated {$mass_fixed} review dates',
    'NextReviewTypeUpdateSuccess' => 'Successfully fixed all review date issues!',
    'NextReviewTypeUpdateFailed' => 'Review dates are fixed, but failed to change the `next_review` column to date type!',
    'SimpleriskBaseUrl' => 'SimpleRisk Base URL',
    'PassworResetEmailSent' => 'If the user exists in the system, then a password reset e-mail should be on its way.',
    'PassworResetRequestFailed' => 'There was a problem with your password reset request. Please try again.',
    'PassworResetSuccessfulRedirectIn5Secs' => 'Your password has been reset successfully. You will be redirected to the login page in 5 seconds.',
    'AlertTimeout' => 'Alert Timeout',
    'TimeoutXSeconds' => '{$timeout} seconds',
    'StayUntilClicked' => 'Stay until clicked',
    'Pass' => 'Pass',
    'Inconclusive' => 'Inconclusive',
    'Fail' => 'Fail',
    'Tags' => 'Tags',
    'NoTagAssigned' => 'No tag assigned yet',
    'AssetNameIsRequired' => 'Asset name is required',
    'TagUpdateAuditLog' => 'User "{$user}" updated tags of {$type}(ID:{$id}) from "{$tags_from}" to "{$tags_to}" ({$tag_changes}).',
    'TagUpdateAuditLogRemoved' => 'Removed "{$tags_removed}"',
    'TagUpdateAuditLogAdded' => 'Added "{$tags_added}"',
    'TagType_risk' => 'Risk',
    'TagType_asset' => 'Asset',
    'YouNeedToSpecifyATypeParameter' => 'You need to specify a type parameter.',
    'Prepend' => 'Prepend',
    'InvalidLastTestDate' => 'Invalid Last Test Date! It\'s either malformed or in the future.',
    'InvalidNextTestDate' => 'Invalid Next TestDate! It\'s either malformed or in the past.',
    'InvalidTestFrequency' => 'Test Frequency must be a positive value!',
    'InvalidApproximateTime' => 'Approximate Time must be a positive value!',
    'InvalidNextTestDateLastTestDateOrder' => 'Next Test Date can\'t be before Last Test Date!',
    'HowToVideos' => 'How-To Videos',
    'FAQs' => 'FAQs',
    'WhatsNew' => 'What\'s New',
    'Roadmap' => 'Roadmap',
    'CommentRiskRequired' => 'Your comment not added to the risk. Please fill the comment field.',
    'NoCommentRiskPermission' => 'You do not have permission to add comments to risks.',
    'NoAccessRiskPermission' => 'You do not have permission to access risks.  Any risks that you attempt to access will not be recorded.  Please contact an Administrator if you feel that you have received this message in error.',
    'RiskLevelTextTop' => 'I consider {$risk_name} risk to be anything greater than or equal to {$risk_value} represented by color {$color_select}.',
    'RiskLevelTextRest' => 'I consider {$risk_name} risk to be less than above, but greater than or equal to {$risk_value} represented by color {$color_select}.',
    'RiskLevelInvalidLevelParameter' => 'Invalid value provided for the \'level\' parameter.',
    'RiskLevelInvalidFieldParameter' => 'Invalid value provided for the \'field\' parameter.',
    'RiskLevelNonNumericValueParameter' => 'The value entered is a non-numeric value.',
    'RiskLevelTooLongValueParameter' => 'The value entered is too long.',
    'RiskLevelInvalidColorParameter' => 'Invalid color',
    'RiskLevelAuditLog' => 'The "{$field}" of risk level "{$name}" was modified from "{$originalValue}" to "{$value}" by user "{$user}".',
    'RiskLevelSuccessfullyUpdated' => 'The configuration was updated successfully.',
    'RiskLevelInvalidValueOrder' => 'Your LOW risk needs to be less than your MEDIUM risk which needs to be less than your HIGH risk which needs to be less than your VERY HIGH risk.',
    'ShowMore' => 'Show More...',
    'ShowXMore' => 'Show {$x} More...',
    'ShowLess' => 'Show Less...',
    'RiskAppetite' => 'Risk Appetite',
    'FailedToCleanupExtraFiles' => 'Failed to clean-up residual extra files thus preventing the install/update to proceed',
    'DocumentExceptions' => 'Define Exceptions',
    'PolicyExceptions' => 'Policy Exceptions',
    'ControlExceptions' => 'Control Exceptions',
    'UnapprovedExceptions' => 'Unapproved Exceptions',
    'ExceptionAdd' => 'Create new exception',
    'ExceptionUpdate' => 'Update exception',
    'ExceptionName' => 'Exception Name',
    'Policy' => 'Policy',
    'ExceptionOwner' => 'Exception Owner',
    'Approver' => 'Approver',
    'ApprovalDate' => 'Approval Date',
    'ReviewFrequency' => 'Review Frequency',
    'Justification' => 'Justification',
    'AreYouSureYouWantToDeleteThisException' => 'Are you sure you want to delete this exception?',
    'YouNeedToSpecifyTheOwnerParameter' => 'You need to specify the owner parameter.',
    'ChooseAPolicyOrControl' => 'Choose either a Policy or a Control',
    'InvalidReviewFrequency' => 'Review Frequency must be a positive value!',
    'InvalidCreationDate' => 'Invalid Creation Date! It\'s either malformed or in the future.',
    'InvalidNextReviewDate' => 'Invalid Next Review Date! It\'s either malformed or in the past.',
    'InvalidApprovalDate' => 'Invalid Approval Date! It\'s either malformed or in the future.',
    'InvalidApprovalDateCreationDateOrder' => 'Approval Date can\'t be before the Creation Date.',
    'ExceptionWasCreatedSuccessfully' => 'Successfully created a Document Exception.',
    'ThereWasAProblemCreatingTheException' => 'There was a problem creating a Document Exception.',
    'ExceptionWasUpdatedSuccessfully' => 'Successfully updated the Document Exception.',
    'ThereWasAProblemUpdatingTheException' => 'There was a problem updating the Document Exception.',
    'ExceptionWasDeletedSuccessfully' => 'Successfully deleted the Document Exception.',
    'ExceptionWasApprovedSuccessfully' => 'Successfully approved the Document Exception.',
    'PolicyExceptionName' => 'Policy/Exception Name',
    'ControlExceptionName' => 'Control/Exception Name',
    'UnapprovedExceptionName' => 'Policy/Control/Exception Name',
    'Ok' => 'Ok',
    'Close' => 'Close',
    'Approve' => 'Approve',
    'ExceptionType' => 'Exception Type',
    'PolicyName' => 'Policy Name',
    'ControlName' => 'Control Name',
    'AreYouSureYouWantToDeleteTheseExceptions' => 'Are you sure you want to delete these exceptions?',
    'ExceptionsWereDeletedSuccessfully_policy' => 'Exceptions of policy were deleted successfully.',
    'ExceptionsWereDeletedSuccessfully_control' => 'Exceptions of control were deleted successfully.',
    'NoPermissionForExceptionView' => 'You don\'t have permission to view the exceptions',
    'NoPermissionForExceptionCreate' => 'You don\'t have permission to create a new exception',
    'NoPermissionForExceptionUpdate' => 'You don\'t have permission to update an exception',
    'NoPermissionForExceptionDelete' => 'You don\'t have permission to delete an exception',
    'NoPermissionForExceptionApprove' => 'You don\'t have permission to approve a Document Exception',
    'AbleToViewDocumentException' => 'Able to View Exceptions',
    'AbleToCreateDocumentException' => 'Able to Create Exceptions',
    'AbleToUpdateDocumentException' => 'Able to Update Exceptions',
    'AbleToDeleteDocumentException' => 'Able to Delete Exceptions',
    'AbleToApproveDocumentException' => 'Able to Approve Exceptions',
    'ExceptionUpdateResetsApproval' => 'Updating an exception makes it unapproved',
    'ExceptionAuditLogCreate' => 'Exception "{$exception_name}" was created by user "{$user}".',
    'ExceptionAuditLogUpdate' => 'Exception "{$exception_name}" was updated by user "{$user}". Changes made: {$changes}.',
    'ExceptionAuditLogUpdateChange' => 'value of "{$key}" was changed from "{$value}" to "{$new_value}"',
    'ExceptionAuditLogDelete' => 'Exception "{$exception_name}" was deleted by user "{$user}".',
    'ExceptionAuditLogApprove' => 'Exception "{$exception_name}" was approved by user "{$user}".',
    'AssetsWereDiscardedSuccessfully' => 'Assets were discarded successfully.',
    'ThereWasAProblemDiscardingTheAssets' => 'There was a problem discarding the assets.',
    'AssetsWereDeletedSuccessfully'=>'Assets were deleted successfully.',
    'ThereWasAProblemDeletingTheAssets'=>'There was a problem deleting the assets.',
    'AssetsWereVerifiedSuccessfully'=>'Assets were verified successfully.',
    'ThereWasAProblemVerifyingTheAssets'=>'There was a problem verifying the assets.',
    'ThereWasAProblemWithAddingTheProject' => 'There was a problem with adding the project',
    'ProjectName' => 'Project Name',
    'SuccessSetProject' => 'Successfully added risk to project.',
    'SuccessCreateProject' => 'Successfully created new project.',
    'ReviewProjectSelectionInstructions' => 'Select a project or type the name of a new one.',
    'ReviewProjectSelectionPlaceholder' => 'Select a project or type a new name',
    'RiskProjectAssociationAuditLog' => 'Risk(ID:{$risk_id}) was assigned to project "{$project_name}" by user "{$user}".',
    'ValuationLevelName' => 'Valuation Level Name',
    'ValuationLevelNameSizeError' => 'Valuation Level Name "{$valuation_level_name}" is too long.',
    'SetUsersOfTeamAuditLog' => 'Users of team "{$team_name}" was set to "{$user_names}" by user "{$username}".',
    'AddUsersToTeamAuditLog' => 'Users "{$user_names}" were added to team "{$team_name}" by user "{$username}".',
    'RemoveUsersFromTeamAuditLog' => 'Users "{$user_names}" were removed from team "{$team_name}" by user "{$username}".',
    'AddUserToTeamsAuditLog' => 'User "{$user_name}" was added to teams "{$team_names}" by user "{$username}".',
    'RemoveUserFromTeamsAuditLog' => 'User "{$user_name}" was removed from teams "{$team_names}" by user "{$username}".',
    'LogType' => 'Log Type',
    'Message' => 'Message',
    'YouCantDownloadBecauseImportExportExtraDisabled' => 'You can not download because Import/Export Extra is disabled.',
    'AuditTrailReport' => 'Audit Trail Report',
    'QuestionnaireAuditTrailReport' => 'Questionnaire Audit Trail Report',
    'ExeptionAuditTrailReport' => 'Exeption Audit Trail Report',
    'ManageAssetGroups' => 'Manage Asset Groups',
    'AssetGroups' => 'Asset Groups',
    'AssetGroupName' => 'Asset Group Name',
    'AssetGroupId' => 'Asset Group ID',
    'SelectedAssets' => 'Selected Assets',
    'AvailableAssets' => 'Available Assets',
    'AssetGroupCreate' => 'Create new Asset Group',
    'AssetGroupUpdate' => 'Update Asset Group',
    'AssetGroupCreateAuditLog' => 'User "{$user}" created Asset Group "{$group_name}"(ID:{$id}) with initial assets of "{$assets_to}".',
    'AssetGroupUpdateAuditLog' => 'User "{$user}" updated assets of Asset Group "{$group_name}"(ID:{$id}) from "{$assets_from}" to "{$assets_to}" ({$asset_changes}).',
    'AssetGroupDeleteAuditLog' => 'User "{$user}" deleted Asset Group "{$group_name}"(ID:{$id}).',
    'AssetGroupUpdateAuditLogRemoved' => 'Removed "{$assets_removed}"',
    'AssetGroupUpdateAuditLogAdded' => 'Added "{$assets_added}"',
    'AssetGroupRemoveAssetAuditLog' => 'User "{$user}" removed Asset "{$asset_name}"(ID:{$asset_id}) from Asset Group "{$group_name}"(ID:{$group_id}).',
    'AssetGroupCreatedSuccessfully' => 'Successfully created new Asset Group.',
    'AssetGroupUpdatedSuccessfully' => 'Successfully updated Asset Group.',
    'AssetGroupDeletedSuccessfully' => 'Successfully deleted Asset Group.',
    'AssetRemovedFromAssetGroupSuccessfully' => 'Successfully removed Asset from its Asset Group.',
    'ThereWasAProblemGettingTheAssetGroup' => 'There was a problem with getting the Asset Group.',
    'ThereWasAProblemCreatingTheAssetGroup' => 'There was a problem with creating the Asset Group.',
    'ThereWasAProblemUpdatingTheAssetGroup' => 'There was a problem with updating the Asset Group.',
    'ThereWasAProblemDeletingTheAssetGroup' => 'There was a problem with deleting the Asset Group.',
    'ThereWasAProblemRemovingTheAssetFromAssetGroup' => 'There was a problem with removing the Asset from its Asset Group.',
    'AreYouSureYouWantToDeleteThisAssetGroup' => 'Are you sure you want to delete this Asset Group?',
    'AreYouSureYouWantToRemoveThisAsset' => 'Are you sure you want to remove this Asset from its Asset Group?',
    'AssetGroupNameAlreadyInUse' => 'This Asset Group name is already in use.',
    'TreegridMissingRequiredParameters' => 'Treegrid request is missing required parameters',
    'UpdateAssetGroupTooltip' => 'Update Asset Group',
    'DeleteAssetGroupTooltip' => 'Delete Asset Group',
    'RemoveAssetTooltip' => 'Remove Asset from Asset Group',
    'ControlShortNameFieldRequired' => 'Control Short Name field is required.',
    'AffectedAssetsWidgetPlaceholder' => 'Select an Asset or Asset Group',
    'AffectedAssetsWidgetNoDropdownPlaceholder' => 'Add an Asset name',
    'AffectedAssetsWidgetInstructions' => 'Select an Asset or Asset Group. You can create a new Asset by adding its name to the list.',
    'ImportAssetGroups' => 'Import Asset Groups',
    'ExportAssetGroups' => 'Export Asset Groups',
    'Assets' => 'Assets',
    'ImportAssetGroupAddSucceeded' => 'Added Asset Group named "{$asset_group_name}".',
    'ImportAssetGroupAddFailed' => 'Failed to add Asset Group named "{$asset_group_name}".',
    'ImportAssetGroupAddNameTaken' => 'Failed to add Asset Group named "{$asset_group_name}" as the name is already in use.',
    'ImportAssetGroupNoop' => 'No operation required on Asset Group named "{$asset_group_name}" as it\'s already in the database.',
    'ImportAssetGroupUpdateSucceeded' => 'Updated Asset Group named "{$asset_group_name}".',
    'ImportAssetGroupUpdateFailed' => 'Failed to update Asset Group named "{$asset_group_name}".',
    'ImportAssetGroupUpdateNameTaken' => 'Failed to update Asset Group named "{$asset_group_name}" as the name is already in use.',
    'GroupMaximumQuantitativeLoss' => 'Group\'s Maximum Quantitative Loss',
    'AssetGroupRisk' => 'Asset Group\'s Risk',
    'NonMitigationNotificationEamilDescription' => 'You are receiving this message because you are the submitter, owner, owner\'s manager, belong to the team, or are an additional stakeholder associated with the following risks without mitigation.  You will continue to receive e-mail reminders until a mitigation has planned.',
    'Manager' => 'Manager',
    'ErrorAssetAlreadyExistsAsVerified' => 'The asset "{$asset_name}" already exists, but not verified yet. Please check your Asset Management page or contact an Admin.',
    'NoPermissionForAssetAssetGroupList' => 'To see the list of available assets, you need permissions for either managing Risks, Assets or Assessments.',
    'NoPermissionForClosingRisks'=>'You do not have the permission to close risks.',
    'QuestionnaireHasNoTemplates' => 'This questionnaire cannot be sent as it doesn\'t have any templates associated',
    'TestAuditWasDeletedSuccessfully' => 'Successfully deleted Test Audit.',
    'TestAuditDeleteAuditTrailMessage' => 'A Test Audit(ID {$test_audit_id}) was deleted by user "{$user}".',
    'CacheClearWarning' => 'Often times new SimpleRisk releases will provide updates to stylesheets, images, and javascript that may have been cached by your web browser.  Please clear your browser cache to ensure that SimpleRisk looks like it should after the upgrade.',
    'TestAddHeader' => 'Add New Test',
    'TestEditHeader' => 'Update Test',
    'ControlEditHeader' => 'Update Control',
    'FrameworkEditHeader' => 'Update Framework',
    'UserTeamUpdateAuditLog' => 'User "{$user}" updated teams of user "{$username}" from "{$teams_from}" to "{$teams_to}" ({$team_changes}).',
    'TeamUpdateAuditLog' => 'User "{$user}" updated teams of {$type} (ID:{$id}) from "{$teams_from}" to "{$teams_to}" ({$team_changes}).',
    'TeamUpdateAuditLogRemoved' => 'Removed "{$teams_removed}"',
    'TeamUpdateAuditLogAdded' => 'Added "{$teams_added}"',
    'ItemUpdateAuditLog' => 'User "{$user}" updated items (type:"{$type}") of team "{$team}" from "{$items_from}" to "{$items_to}" ({$item_changes}).',
    'ItemUpdateAuditLogRemoved' => 'Removed "{$items_removed}"',
    'ItemUpdateAuditLogAdded' => 'Added "{$items_added}"',
    'TeamType_test' => 'Test',
    'TeamType_audit' => 'Audit',
    'TestCreatedAuditLogMessage' => 'Test "{$test_name}"(ID: {$test_id}) was created by user "{$user}".',
    'TestUpdatedAuditLogMessage' => 'Test "{$test_name}"(ID: {$test_id}) was updated by user "{$user}".',
    'TestDeletedAuditLogMessage' => 'Test "{$test_name}"(ID: {$test_id}) was deleted by user "{$user}".',
    'AllowControlOwnerToSeeTestAndAuditDetails' => 'Allow Control Owner to see Test/Audit details',
    'AllowTesterToSeeTestAndAuditDetails' => 'Allow Tester to see Test/Audit details',
    'AllowAssignedTeamsMembersToSeeTestAndAuditDetails' => 'Allow members of Assigned Teams to see Test/Audit details',
    'AllowStakeholdersToSeeTestAndAuditDetails' => 'Allow Stakeholders to see Test/Audit details',
    'AllowEveryoneToSeeTestAndAuditDetails' => 'Allow Everyone to see Test/Audit details',
    'NoPermissionForThisTest' => 'You have no permission to access this Test',
    'NoPermissionForThisAudit' => 'You have no permission to access this Audit',
    'SuccessUpdatingCustomScore' => 'Successfully updated custom score.',
    'InvalidImpactOrLikelihood' => 'Invalid Impact Or Likelihood!',
    'RiskScoreIsOutOfRange' => 'The score should be between 0 and 10 (inclusive).',
    'ExportControls' => 'Export Controls',
    'ImportControlCreatedAndAdded' => 'Created control "{$short_name}" and added to framework(s) "{$control_frameworks}".',
    'ImportControlCreated' => 'Created control "{$short_name}".',
    'ImportControlUpdated' => 'Updated control "{$short_name}"(ID: {$control_id}).',
    'SelectForControls' => 'Select for controls',
    'DeleteControls' => 'Delete Controls',
    'SelectControlsToDelete' => 'Please select controls to delete.',
    'AreYouSureYouWantToDeleteControls' => 'Are you sure you want to delete the selected controls?',
    'FirstName' => 'First Name',
    'LastName' => 'Last Name',
    'AdvancedSearch' => 'Advanced Search',
    'AdvancedSearchExtra' => 'Advanced Search Extra',
    'ExtraToggledOn' => 'The extra "{$extra_name}" was toggled on by user "{$user}".',
    'ExtraToggledOff' => 'The extra "{$extra_name}" was toggled off by user "{$user}".',
    'RiskSearch' => 'Risk Search',
    'SearchResults' => 'Search Results',
    'NoSearchResults' => 'No results found for your query.',
    'FitlerForGroup' => 'FILTER FOR GROUP',
    'ErrorInSearchQuery' => 'Error in search query',
    'ManagerAttribute' => 'MANAGER ATTRIBUTE',
    'AutomaticallyAddNewUserForManagerIfTheyNoExist' => 'Automatically add a new user account for a manager if they do not exist',
    'UPGRADECOMPLETED' => 'UPGRADE COMPLETED',
    'NotifyPolicyOwner' => 'Notify Policy Owner',
    'NotifyApprover' => 'Notify Approver',
    'AutomatedNotificationsOfUnReviewedPastdueControlPolicyExceptions' => 'Automated Notifications of Unreviewed / Past Due Policy and Control Exceptions',
    'PolicyControlExeptionReviewNotificationEamilDescription' => 'You are receiving this message because you are the Policy or Control owner, Approver, or are an additional stakeholder associated with the following Policy and Control Exceptions which are due for review.  You will continue to receive e-mail reminders until an Exception has approved.',
    'AutomatedNotificationsOfUnmitigatedRisks' => 'Automated Notifications of Unmitigated Risks',
    'SelectForAffectedAssets' => 'Select for affected assets',
    'SearchForQuestion' => 'Search for question',
    'Required' => 'Required',
    'ThereAreRequiredFields' => 'There are required fields.',
    'ThisFieldIsRequired' => 'This field is required.',
    'ThereAreUnexpectedProblems' => 'There are unexpected problems.',
    'PleaseSelectTypeForSaving' => 'Please select type for saving selections.',
    'SavedSelections' => 'Saved',
    'SaveSelections' => 'Save selections',
    'Private' => 'Private',
    'Public' => 'Public',
    'TheNameAlreadyExists' => 'The name already exists. Please try another name.',
    'NoPermissionForSelection' => 'You have no permission to access the selection',
    'RiskAppetiteReport' => 'Risk Appetite Report',
    'WithinAppetite' => 'Within Appetite',
    'OutsideAppetite' => 'Outside Appetite',
    'UpdateCustomField' => 'Update Custom Field',
    'TheNameFieldIsRequired' => 'The name field is required.',
    'SuccessfullyUpdatedCustomField' => 'Successfully updated this custom field.',
    'All' => 'All',
    'UpdateStart' => 'Update Started.',
    'UpdateFailed' => 'Update Failed. Please contact an Administrator.',
    'UpdateSuccessful' => 'Update Successful. The application, the database and all your installed extras are up-to-date.',
    'UpdateVersionCheck' => 'Checking versions...',
    'UpdateVersionCheckDone' => 'Version checking done.',
    'UpdateApplicationFilesOutOfDate' => 'Application files are out-of-date. Current version: "{$current}", Latest Version: "{$latest}"',
    'UpdateApplicationFilesUpToDate' => 'Application files are up-to-date.',
    'UpdateDatabaseOutOfDate' => 'Database version is not matching the Application version. Application version: "{$app_version}", Database Version: "{$db_version}"',
    'UpdateDatabaseMustFollowAppVersion' => 'Application will be updated and the Database Version must follow. Latest Application version: "{$app_version}", Database Version: "{$db_version}"',
    'UpdateDatabaseUpToDate' => 'Database version is matching the Application version, no update required.',
    'UpdateInstalledExtrasOutOfDate' => 'Extra(s) out-of-date. The following extra(s) need to be updated: "{$extrasToUpdate}"',
    'UpdateInstalledExtrasUpToDate' => 'Extras are up-to-date.',
    'UpdateNoUpdateRequired' => 'Everything is up-to-date. No update is required.',
    'UpdateExtraInvalidName' => 'Invalid extra name "{$name}".',
    'UpdateExtraNoPermissionForSimpleriskDirectory' => 'The "{$simplerisk_dir}" directory is not writeable by the web user.',
    'UpdateExtraNoPermissionForExtrasDirectory' => 'Unable to create the "{$extras_dir}" directory.',
    'UpdateExtrasStarted' => 'Extra Updates Started.',
    'UpdateExtrasSuccessful' => 'Extras Successfully updated.',
    'UpdateExtrasExtraUpdateStarted' => 'Started update on extra "{$extra}".',
    'UpdateExtrasUpdateExtraFailed' => 'Extra "{$extra}" update failed, aborting extra updates.',
    'BackupStart' => 'Backup Started.',
    'BackupFailed' => 'Backup Failed. Please contact an Administrator.',
    'BackupSuccessful' => 'Backup Successful. The application, the database and all your installed extras are backed up.',
    'BackupCheckingPreRequisites' => 'Checking permissions, setting up directories.',
    'BackupCheckingPreRequisitesDone' => 'Permission checks passed, required directories successfully created.',
    'BackupApplicationFiles' => 'Application files backup started.',
    'BackupApplicationFilesDone' => 'Application files successfully backed up',
    'BackupDatabase' => 'Database backup started.',
    'BackupDatabaseDone' => 'Database successfully backed up.',
    'BackupDirectoryNotWriteable' => 'The "{$location}" directory is not writeable by the web user.',
    'BackupFailedToCreateDirectories' => 'Unable to create the required directory structure at "{$location}".',
    'AreYouSureYouWantToDeleteSelction' => 'Are you sure you want to delete the selection?',
    'FieldIsRequired' => '_XXX_ field is required',
    'NoPermissionForAssessments' => 'You don\'t have permission for Assessments.',
    'Encrypted' => 'Encrypted',
    'AreYouSureYouWantToApproveThisResult' => 'Are you sure you want to approve this result?',
    'AreYouSureYouWantToRejectThisResult' => 'Are you sure you want to reject this result?',
    'Reject' => 'Reject',
    'RejectComment' => 'Reject comment(optional)',
    'QuestionnaireResultApprovedMessage' => 'Reviewed and Approved by {$user} on {$timestamp}.',
    'QuestionnaireResultApprovedSuccessfully' => 'Questionnaire result successfully approved.',
    'QuestionnaireResultRejectedSuccessfully' => 'Questionnaire result successfully rejected. Notification email is sent to the contact.',
    'EmailTemplateRejectedQuestionnaireResult' => '
        <html><body>
            Hello,
            <p> {$username} has asked you to re-evaluate the following risk assessment questionnaire:</p>
            <p><a href="{$assessment_link}"> {$assessment_name} </a></p>
            <p>Comments: {$reject_comment}</p>
            <p>This is an automated message and responses will be ignored or rejected.</p>
        </body></html>',
    'QuestionnaireResultApprovedAuditLog' => 'Questionnaire "{$questionnaire_name}"(sent to contact "{$contact_name}" on "{$date}") result was approved by user "{$user_name}".',
    'QuestionnaireResultRejectedAuditLog' => 'Questionnaire "{$questionnaire_name}" result was rejected and sent back to contact "{$contact_name}" for re-evaluation by user "{$user_name}" with comment "{$reject_comment}".',
    'PrePopulateWithAnswersFromLastAssessment' => 'Pre-populate with answers from last assessment?',
    'QuestionnaireResultCommentAuditLog' => 'User "{$user_name}" added a comment for questionnaire "{$questionnaire_name}" (sent to contact "{$contact_name}" on "{$date}") result.',
    'QuestionnaireSentAuditLog' => 'Questionnaire "{$questionnaire_name}" was sent to contact "{$contact_name}" by user "{$user_name}".',
    'PendingRiskCreationAuditLog' => 'Questionnaire "{$questionnaire_name}"\'s completion resulted in creating pending risk "{$subject}".',
    'PendingRiskAddAuditLog' => 'Pending risk "{$subject}" of questionnaire "{$questionnaire_name}"(sent to contact "{$contact_name}" on "{$date}") was added as Risk(ID: {$risk_id}) by user "{$user_name}".',
    'PendingRiskDeleteAuditLog' => 'Pending risk "{$subject}" of questionnaire "{$questionnaire_name}"(sent to contact "{$contact_name}" on "{$date}") was deleted by user "{$user_name}".',
    'PendingRiskDeleteAllAuditLog' => 'Pending risks of questionnaire "{$questionnaire_name}"(sent to contact "{$contact_name}" on "{$date}") were deleted by user "{$user_name}".',
    'QuestionnaireCompletedAuditLog' => 'Questionnaire "{$questionnaire_name}" was completed by contact "{$contact_name}".',
    'QuestionnaireDraftAuditLog' => 'Questionnaire "{$questionnaire_name}" was saved as draft by contact "{$contact_name}".',
    'QuestionnaireResultAuditTrailReport' => 'Questionnaire Result Audit Trail Report',
    'SubTemplate' => 'Sub Template',
    'MitigationAccepted' => 'Mitigation Accepted',
    'FilterBy' => 'Filter by',
    'AddNewQuestion' => 'Add new question',
    'ControlAudit' => 'Control Audit',
    'AssociatedControls' => 'Associated Controls',
    'AssociatedFrameworks' => 'Associated Frameworks',
    'Analysis' => 'Analysis',
    'TotalNumber' => 'Total Number',
    'CumulativeScore' => 'Cumulative Score',
    'AverageScore' => 'Average Score',
    'AddedRisks' => 'Added Risks',
    'RejectedRisks' => 'Rejected Risks',
    'RiskAnalysis' => 'Risk Analysis',
    'AllRisksFromQuestionnaires' => 'All Risks from Questionnaires',
    'AllAddedRisksFromQuestionnaires' => 'All Added Risks from Questionnaires',
    'AllPendingRisksFromQuestionnaires' => 'All Pending Risks from Questionnaires',
    'AddedRisk' => 'Added Risk',
    'PendingRisk' => 'Pending Risk',
    'Undefined' => 'Undefined',
    'SendingRequestPleaseWait' => 'Sending request. Please wait.',
    'ApplicationNeedsToBeUpgradeToLatestVersionToUpgradeExtras' => 'Application needs to be upgraded to the latest version to upgrade extras.',
    'FilteredRiskReport' => 'Filtered Risk Report',    
    'NoPermissionForThisAction'=>'You don\'t have permission this action.',
    'QuestionnaireResult'=>'Questionnaire Result',
    'ChangedField' => 'Changed Field',
    'ChangedFrom' => 'Changed From',
    'ChangedTo' => 'Changed To',

    'Jira' => 'Jira',
    'JiraExtra' => 'Jira Extra',

    'JiraWebhookAuthTokenIsInvalid' => 'The provided Jira Webhook Auth Token("{$token}") is invalid!',
    'JiraWebhookNoBodyPosted' => 'The jira webhook did not post a body! Please contact support@simplerisk.com',
    'JiraWebhookBodyPostedIsInvalid' => 'The body provided by the jira webhook is invalid!',

    'JiraConnectionSettings' => 'Connection Settings',    
    'JiraInstanceURL' => 'Jira Instance URL',
    'JiraInstanceURLInstructions' => 'For example: https://your-domain.atlassian.net/',
    'JiraUserEmail' => 'Jira User\'s Email',
    'JiraUserAPIKey' => 'Jira User\'s API Key',
    'JiraInvalidCredentials' => 'Invalid credentials! Can\'t connect to the jira instance with the specified email and API key.',
    'JiraInstanceURLIsRequired' => 'Jira Instance URL is required!',
    'JiraUserEmailIsRequired' => 'Jira User\'s Email is required!',
    'JiraUserAPIKeyIsRequired' => 'Jira User\'s API Key is required!',
    'JiraInstanceURLIsInvalid' => 'Invalid Jira Instance URL or the Jira Instance is down!',
    'JiraServerInfoNotAccessible' => 'The Jira instance\'s server info endpoint is not accessible, can\'t determine if server is supporting webhooks.',
    'JiraServerInfoInvalidOrMissingBuildNumber' => 'The Jira instance\'s build number is either invalid or missing, can\'t determine if server is supporting webhooks.',
    'JiraWebhookNotSupported' => 'The configured Jira instance is not supporting webhooks. The minimum version that is supporting webhooks is 5.2(Build Number 810+).',
    'JiraWebhookNotSupportedOnHttp' => 'You have to run your SimpleRisk instance on https to be able to use this extra.',
    'JiraConnectionSettingsWarning' => 'Your connection settings are invalid. Synchronization and access to the Synchronization settings is disabled.',
    'JiraConnectionSettingsSuccess' => 'Your connection settings are valid. Synchronization is enabled.',
    'JiraWebhookSetupFailed' => 'Setting up webhook failed. Please check your connection settings.',
    'JiraWebhookSetupSuccess' => 'Webhook successfully set up.',

    'JiraProjectSynchronizationSettings' => 'Project Synchronization Settings',
    'JiraFailedGetIssueTypes' => 'Failed to get issue types! Please contact an Administrator.',
    'JiraFailedGetStatuses' => 'Failed to get available statuses! Please contact an Administrator.',
    'JiraCreateIssueOnNewRisk' => 'Allow SimpleRisk to create new Jira issues when a Risk is created.',
    'JiraProjectKeyForNewIssue' => 'Project Key',
    'JiraProjectKeyForNewIssueIsRequired' => 'Project Key key is required!',
    'JiraProjectKeyForNewIssueIsInvalid' => 'No project could be found with the specified key!',
    'JiraProjectKeyForNewIssueIsMalformed' => 'The specified Project Key contains invalid characters.',
    'JiraIssueTypeForNewIssue' => 'Issue Type',
    'JiraIssueTypeForNewIssueInstructions' => 'Please select "Task"! This step is required as we can\'t identify the "Task" issue type with a 100% certainty based on the data the Jira instance is providing. If for your use-case you\'d need support for other issue types as well, please contact support@simplerisk.com.',
    
    'JiraCreateRiskOnNewIssue' => 'Allow SimpleRisk to create new Risk when a new Jira issue is detected.',
    'JiraScanProjectsForNewIssues' => 'Scan Projects',
    'JiraScanProjectsForNewIssuesInstructions' => 'SimpleRisk will check these projects for new issues.',
    'JiraImportExistingIssues' => 'Import already existing issues.',
    'JiraImportExistingIssuesInstructions' => 'The import will be done on the next run of the scheduled sync.',

    'JiraGeneralSynchronizationSettings' => 'General Synchronization Settings',
    
    'JiraSynchronizationConflict' => 'Conflict',
    'JiraSynchronizationConflictDescription' => 'Choose that on conflicting field values the Risk\'s or the Jira Issue\'s version should be used. Same logic applies to the first synchronization after a Jira issue is assigned to a risk.',
    'JiraUseRiskValueOnConflict' => 'Use the Risk\'s value (default)',
    'JiraUseIssueValueOnConflict' => 'Use the Jira Issue\'s value',

    'JiraSynchronizationFields' => 'Fields',
    'JiraSynchronizeStatus' => 'Enable synchronization of "Status"',
    'JiraSynchronizeStatusSelectionInstructions' => 'Please select a status that can be freely transitioned to from any of the statuses used in your projects\' workflows and is available for all your projects.',
    'JiraSynchronizeStatusInstructions' => 'Decide what should happen on certain status transitions',
    'JiraSynchronizeStatus_RiskClose' => 'Close Risk when the associated Jira Issue is closed',
    'JiraSynchronizeStatus_IssueClose' => 'Close Jira Issue when the associated Risk is closed',
    'JiraSynchronizeStatus_IssueClose_SetStatus' => 'Set status of Jira Issue to',
    'JiraSynchronizeStatus_RiskReopen' => 'Reopen Risk when the associated Jira Issue is reopened',
    'JiraSynchronizeStatus_RiskReopen_SetStatus' => 'Set status of Risk to',
    'JiraSynchronizeStatus_IssueReopen' => 'Reopen Jira Issue when the associated Risk is reopened',
    'JiraSynchronizeStatus_IssueReopen_SetStatus' => 'Set status of Jira Issue to',
    'JiraSynchronizeDescription' => 'Enable synchronization of "Description"',
    'JiraSynchronizeDescriptionWith' => 'Synchronize with',
    'JiraSynchronizeDescriptionWithInstructions' => 'Select which field to synchronize the jira issues\' Description with.',
    'JiraSynchronizeSummary' => 'Enable synchronization of risk field "Subject" with jira issue\'s "Summary"',

    'JiraSynchronizationMethod' => 'Method',
    'JiraAllowWebhookManagement' => 'Allow the SimpleRisk instance to manage Webhooks on the Jira instance',
    'JiraAllowWebhookManagementInstructions' => 'The Jira user needs to have permission to manage webhooks for this option to work.',
    'JiraUseScheduledSyncOnly' => 'Use the scheduled synchronization only(changes may take up to a few minutes to appear in the other system)',

    'JiraIssueKey' => 'Jira Issue Key',
    'JiraIssueKeyIsMalformed' => 'Invalid Jira Issue Key format.',
    'JiraIssueKeyIsInvalid' => 'Issue does not exist or you do not have permission to see it.',
    'JiraIssueKeyIsAlreadyInUse' => 'The specified Jira Issue Key is already assigned to a Risk(ID: {$risk_id}).',

    'JiraFailedToSynchronizeRiskWithIssue' => 'Failed to synchronize Risk(ID: {$risk_id}) with Jira Issue(Key: {$issue_key}).',
    'JiraRiskUpdatedFromJiraAuditLog' => 'Risk (ID: {$risk_id}) updated from Jira Issue(Key: {$issue_key}). Field "{$field}" changed from "{$from}" to "{$to}".',
    
    'IDNumber' => 'ID #',
    'UCFAPIKeyIsRequired' => 'A valid UCF API key is required!',
    'UCFConnectionSettingsSuccess' => 'Your connection settings are valid and we successfully connected to the UCF server.',
    'UCFConnectionSettingsWarning' => 'Your connection settings are invalid and we are unable to communicate with the UCF server',
    'InitiateAudit'=>'Initiate Audit',
    'ViewActiveAudits'=>'View Active Audits',
    'ViewPastAudits'=>'View Past Audits',
    'Uninstall' => 'Uninstall',
    'SimpleriskUsers' => 'Simplerisk Users',
    'QuestionnaireCompletedAuditLogByUser' => 'Questionnaire "{$questionnaire_name}" was completed by user "{$contact_name}".',
    'QuestionnaireDraftAuditLogByUser' => 'Questionnaire "{$questionnaire_name}" was saved as draft by user "{$contact_name}".',
    'Internal' => 'Internal',
    'AnswerType' => 'Answer Type',
    'MultipleChoice' => 'Multiple Choice',
    'FillInTheBlank' => 'Fill in the Blank',
    'Proxy' => 'Proxy',
    'ProxyWebRequests' => 'Proxy Web Requests',
    'VerifySSLCertificate' => 'Verify SSL Certificate',
    'ProxyHostname' => 'Proxy Hostname / IP',
    'ProxyPort' => 'Proxy Port',
    'AuthenticatedProxy' => 'Authenticated Proxy',
    'ProxyUsername' => 'Proxy Username',
    'ProxyPassword' => 'Proxy Password',
    'SimpleRiskExtras' => 'SimpleRisk Extras',
    'ColumnSelections' => 'Column Selections',
    'GroupAndFilteringSelections' => 'Group and Filtering Selections',
    'Hyperlink' => 'Hyperlink',
    'URL' => 'URL',
    'AssetTeams'=>'Asset Team(s)',
    'AssetSiteLocation'=>'Asset Site/Location',
    'ActivatingSCFMessage' => 'Installing the Secure Controls Framework (SCF) framework. This can take several minutes to complete.',
    'DeactivatingSCFMessage' => 'Uninstalling the Secure Controls Framework (SCF) framework.',
    'UpdatingSCFMessage' => 'Updating the Secure Controls Framework (SCF) framework. This can take several minutes to complete.',
    'Processing' => 'Processing...',
    'AlphabeticalOrder'=>'Alphabetical Order',
    'UserReports'=>'User Reports',
    'UsersHeader'=>'Users',
    'Usernames'=>'Usernames',
    'TeamsHeader'=>'Teams',
    'TeamNames'=>'Team Names',
    'YouNeedTeamSeparationEnabled' => 'You need to have the Team Separation extra enabled for this functionality.',
    'DocumentOwner' => 'Document Owner',
    'FieldRequired' => '{$field} field is required',
    'AddUsers' => 'Add Users',
    'ManageUsers' => 'Manage Users',
    'UserSettings' => 'User Settings',
    'AbleToAddProjects' => 'Able to Add Projects',
    'AbleToDeleteProjects' => 'Able to Delete Projects',
    'AbleToManageProjects' => 'Able to Manage Projects',
    'MitigationPlannedVsUnplanned' => 'Mitigation Planned vs Unplanned',
    'Scheduled' => 'Scheduled',
    'AbleToDefineTests' => 'Able to Define Tests',
    'AbleToEditTests' => 'Able to Edit Tests',
    'AbleToDeleteTests' => 'Able to Delete Tests',
    'AbleToInitiateAudits' => 'Able to Initiate Audits',
    'AbleToModifyAudits' => 'Able to Modify Audits',
    'AbleToReopenAudits' => 'Able to Reopen Audits',
    'AbleToDeleteAudits' => 'Able to Delete Audits',
    'ReportDisplayed' => 'Report Displayed',
    'UsersWithoutTeam' => '<Users without a Team>',
    'NoRole' => '<No Role>',
    'NoUser' => '<No User>',
    'UsersOfTeams' => 'Users of Teams',
    'TeamsOfUsers' => 'Teams of Users',
    'UsersOfPermissions' => 'Users of Permissions',
    'PermissionsOfUsers' => 'Permissions of Users',
    'Roles' => 'Roles',
    'Permissions' => 'Permissions',
    'UsersOfRoles' => 'Users of Roles',
    'UsersWithoutPermission' => '<Users without a Permission>',
    'CustomFieldUpdateFailed' => 'Failed to update custom field.',
    'IncidentManagement' => 'Incident Management',
    'IncidentManagementExtra' => 'Incident Management Extra',
    'Incident' => 'Incident',
    'NewIncident' => 'New Incident',
    'Preparation' => 'Preparation',
    'Identification' => 'Identification',
    'Response' => 'Response',
    'Containment' => 'Containment',
    'Eradication' => 'Eradication',
    'Recovery' => 'Recovery',
    'LessonsLearned' => 'Lessons Learned',
    'SubmitAnIncident' => 'Submit An Incident',
    'GovernanceRiskCompliance' => 'Governance Risk & Compliance',
    'Incidents' => 'Incidents',
    'Detection' => 'Detection',
    'Assignment' => 'Assignment',
    'Prioritization' => 'Prioritization',
    'Associations' => 'Associations',
    'Location' => 'Location',
    'DetectionDate' => 'Detection Date',
    'OccurrenceType' => 'Occurrence Type',
    'OrganizationalHierarchy' => 'Organizational Hierarchy',
    'OrganizationalHierarchyExtra' => 'Organizational Hierarchy Extra',
    'OrganizationalHierarchyDisabledWarning' => 'If you don\'t have the Team-Based Separation extra activated, then Organizational Hierarchy will be limited to filtering the view, not restricting access to data.',
    'OrganizationalHierarchyDisabled' => 'Organizational Hierarchy extra is disabled',
    'BusinessUnits' => 'Business Units',
    'CreateNewBusinessUnit' => 'Create New Business Unit',
    'Create' => 'Create',
    'SelectedTeams' => 'Selected Teams',
    'AvailableTeams' => 'Available Teams',
    'BusinessUnitUpdate' => 'Update Business Unit',
    'BusinessUnitCreateAuditLog' => 'User "{$user}" created Business Unit "{$business_unit_name}"(ID:{$id}) with initial teams of "{$teams_to}".',
    'BusinessUnitUpdateAuditLog' => 'User "{$user}" updated teams of Business Unit "{$business_unit_name}"(ID:{$id}) from "{$teams_from}" to "{$teams_to}" ({$team_changes}).',
    'BusinessUnitDeleteAuditLog' => 'User "{$user}" deleted Business Unit "{$business_unit_name}"(ID:{$id}).',
    'BusinessUnitUpdateAuditLogRemoved' => 'Removed "{$teams_removed}"',
    'BusinessUnitUpdateAuditLogAdded' => 'Added "{$teams_added}"',
    'BusinessUnitRemoveTeamAuditLog' => 'User "{$user}" removed Team "{$team_name}"(ID:{$team_id}) from Business Unit "{$business_unit_name}"(ID:{$business_unit_id}).',
    'BusinessUnitCreatedSuccessfully' => 'Successfully created new Business Unit.',
    'BusinessUnitUpdatedSuccessfully' => 'Successfully updated Business Unit.',
    'BusinessUnitDeletedSuccessfully' => 'Successfully deleted Business Unit.',
    'BusinessUnitSelectedSuccessfully' => 'Successfully selected Business Unit.',
    'TeamRemovedFromBusinessUnitSuccessfully' => 'Successfully removed Team from its Business Unit.',
    'ThereWasAProblemGettingTheBusinessUnit' => 'There was a problem with getting the Business Unit.',
    'ThereWasAProblemCreatingTheBusinessUnit' => 'There was a problem with creating the Business Unit.',
    'ThereWasAProblemUpdatingTheBusinessUnit' => 'There was a problem with updating the Business Unit.',
    'ThereWasAProblemDeletingTheBusinessUnit' => 'There was a problem with deleting the Business Unit.',
    'ThereWasAProblemSelectingTheBusinessUnit' => 'There was a problem with selecting the Business Unit.',
    'ThereWasAProblemRemovingTheTeamFromBusinessUnit' => 'There was a problem with removing the Team from its Business Unit.',
    'AreYouSureYouWantToDeleteThisBusinessUnit' => 'Are you sure you want to delete this Business Unit?',
    'AreYouSureYouWantToRemoveThisTeam' => 'Are you sure you want to remove this Team from its Business Unit?',
    'BusinessUnitNameAlreadyInUse' => 'This Business Unit name is already in use.',
    'UpdateBusinessUnitTooltip' => 'Update Business Unit',
    'DeleteBusinessUnitTooltip' => 'Delete Business Unit',
    'RemoveTeamTooltip' => 'Remove Team from Business Unit',
    'YouNeedToSpecifyATeamParameter' => 'You need to specify a Team parameter.',
    'OrganizationManagement' => 'Organization Management',
    'Source' => 'Source',
    'SourceType' => 'Source Type',
    'DetectedBy' => 'Detected By',
    'Direction' => 'Direction',
    'Reporter' => 'Reporter',
    'FunctionalImpact' => 'Functional Impact',
    'Functional' => 'Functional',
    'InformationImpact' => 'Information Impact',
    'Information' => 'Information',
    'Locations' => 'Locations',
    'Region' => 'Region',
    'Regions' => 'Regions',
    'Country' => 'Country',
    'Countries' => 'Countries',
    'City' => 'City',
    'Cities' => 'Cities',
    'Communications' => 'Communications',
    'Facilities' => 'Facilities',
    'Hardware' => 'Hardware',
    'Software' => 'Software',
    'Resources' => 'Resources',
    'NewIncidentInstruction' => 'Complete the form above to document a new incident.',
    'SubmitIncident' => 'Submit Incident',
    'IncidentSubmitSuccess' => 'Incident ID "{$incident_id}" has been submitted successfully.',
    'RelatedIncidents' => 'Related Incidents',
    'RelatedRisks' => 'Related Risks',
    'IncidentTags_source' => 'Source Tags',
    'IncidentTags_destination' => 'Destination Tags',
    'Severity' => 'Severity',
    'IncidentDetails' => 'Incident Details',
    'EventDetails' => 'Event Details',
    'Evidence' => 'Evidence',
    'Notes' => 'Notes',
    'NewEvidence' => 'New Evidence',
    'DeleteEvidence' => 'Delete Evidence',
    'EditEvidence' => 'Edit Evidence',
    'EvidenceLabel' => 'Evidence Label',
    'IdentifyingInformation' => 'Identifying Information',
    'CollectedOn' => 'Collected On',
    'CollectedBy' => 'Collected By',
    'AreYourSureYouWantToDeleteThisEvidence' => 'Are You Sure You Want to Delete This Evidence?',
    'DetectedOn' => 'Detected On',
    'BeganOn' => 'Began On',
    'ReportedBy' => 'Reported By',
    'OwnedBy' => 'Owned By',
    'NoneSelected' => 'None Selected',
    'Playbook' => 'Playbook',
    'NoLocationInformationSpecified' => 'No location information was specified for this incident',
    'NoAssociationInformationSpecified' => 'No association information was specified for this incident',
    'IncidentDoesNotExistOrPermissionDenied' => 'Either the specified incident ID does not exist or you do not have permission to view it.',
    'AutomatedNotificationsOfDocumentReviews' => 'Automated Notifications of Document Reviews',
    'DocumentReviewsNotificationEmailTitle' => 'You are receiving this message because you are the owner or are an additional stakeholder associated with the following Documents.  You will continue to receive e-mail reminders until the Document has been updated.',
    'ControlValidation' => 'Control Validation',
    'MappedControlFrameworks' => 'Mapped Control Frameworks',
    'AddMappingFrameworks' => 'Add Mapping Frameworks',
    'EditMappingFrameworks' => 'Edit Mapping Frameworks',
    'AreYouSureYouWantToDeleteThisMappedControlFramework' => 'Are you sure you want to delete this mapped control framework?',
    'ReferenceName' => 'Reference Name',
    'RiskGrouping' => 'Risk Grouping',
    'RiskGroupings' => 'Risk Groupings',
    'RiskFunctions' => 'Risk Functions',
    'RiskCatalog' => 'Risk Catalog',
    'RiskEvent' => 'Risk Event',
    'Function' => 'Function',
    'AreYouSureYouWantToDeleteThisRiskCatalog' => 'Are you sure you want to delete this risk catalog item?',
    'RequireRiskMappingForAllRisks' => 'Require a Risk Mapping for all risks',
    'RiskMapping' => 'Risk Mapping',
    'ActiveRisks' => 'Active Risks',
    'AreYouSureYouWantToDeleteThisIncident' => 'Are you sure you want to delete this incident?',
    'AreYouSureYouWantToDeleteThisNote' => 'Are you sure you want to delete this note?',
    'IncidentWasDeletedSuccessfully' => 'Incident was deleted successfully',
    'EditIncidentDetails' => 'Edit Incident Details',
    'AddNote' => 'Add Note',
    'UploadedBy' => 'Uploaded By',
    'NoPermissionForIncidentManagement' => 'You have no permission for incident management.',
    'TagType_Incident_source' => 'Incident - Source',
    'TagType_Incident_destination' => 'Incident - Destination',
    'PleaseSelectAPlaybookFromTheAboveDropdown' => 'Please select a playbook from the above dropdown',
    'AssetTags' => 'Asset Tags',
    'UserPermissionUpdateAuditLog' => 'User "{$user}" updated permissions of user "{$username}" from "{$permissions_from}" to "{$permissions_to}" ({$permission_changes}).',
    'PermissionUpdateAuditLogRemoved' => 'Removed "{$permissions_removed}"',
    'PermissionUpdateAuditLogAdded' => 'Added "{$permissions_added}"',
    'Admin' => 'Admin',
    'AdminRoleDescription' => 'This permission provides access to SimpleRisk\'s configurations. A user with this permission is effectively an administrative user on the system. They are able to make changes to any and all menus found in the "Configure" menu. This will also allow for the activation and de-activation of Extras and modifying their configurations. This permission should only be given to those who have absolute need of it. Once a user has access to this permission they will be able to edit other user accounts as well.',
    'GrantAdmin' => 'Grant Admin',
    'RemoveAdmin' => 'Remove Admin',
    'WouldYouLikeSimpleRiskToAutomaticallyGenerate' => 'Would you like SimpleRisk to automatically generate a questionnaire template based on selected frameworks and controls?',
    'GenerateStandardQuestionnaireTemplate' => 'Generate a Standard Questionnaire Template',
    'GenerateMaturityQuestionnaireTemplate' => 'Generate a Maturity Questionnaire Template',
    'CantDeleteComplianceForgeSCFFramework' => 'You can\'t delete the Secure Controls Framework (SCF) framework.',
    'CantDeleteUnassignedFramework' => 'You can\'t delete the Unassigned framework.',
    'LicenseCheckFailed' => 'One or more of your SimpleRisk Extras has failed the license check and may be disabled or deleted within the next 30 days. Please contact support immediately to renew your license.',
    'JiraProjectForNewIssue' => 'Jira Project',
    'JiraProjectForNewIssueIsRequired' => 'Project is required!',
    'JiraScanProjectsForNewIssuesIsInvalid' => 'No project could be found with the specified key("{$key}")!',
    'JiraProjectForNewIssueIsInvalid' => 'No project could be found with the specified ID!',
    'JiraIssueTypeForNewIssueIsRequired' => 'Jira Issue Type is required!',
    'JiraFailedGetProjects' => 'Failed to get available projects! Please contact an Administrator.',
    'JiraProjectOrIssueTypeForNewIssueIsNotValid' => 'Jira Project or Issue Type provided isn\'t valid.',
    'JiraSuccessfullyCreatedIssue' => 'Successfully created a Jira Issue({$key}).',
    'JiraFailedToCreateIssue' => 'Failed to create Jira Issue! Please contact an Administrator.',
    'JiraPopulateDescriptionWith' => 'Populate Description with',
    'JiraPopulateDescriptionWithInstructions' => 'Select which risk field to populate the jira issues\' Description with.',
    'JiraUserEmailInstructions' => 'For Jira Core instances you have to specify the Jira Username',
    'JiraUserAPIKeyInstructions' => 'For Jira Core instances you have to specify the Jira User\'s password',
    'SCFMappings' => 'SCF Mappings',
    'ActivatingSCFMappingMessage' => 'Installing the SCF Mapping from Github. This can take several minutes to complete.',
    'DeactivatingSCFMappingMessage' => 'Uninstalling the SCF Mapping.',
    'Content' => 'Content',
    'Dismiss' => 'Dismiss',
    'NewLessonLearned' => 'New Lesson Learned',
    'CurrentLessonsLearned' => 'Current Lessons Learned',
    'AnswersDynamicallyCreated' => 'Answers will be dynamically created for this question.',
    'TheRequestedAPIEndpointWasNotFound' => 'The requested API endpoint was not found',
    'MaxTagLengthWarning' => 'The maximum length of a tag is 255 characters.',
    'RiskTagTruncatedWarning' => 'Risk {$risk_id}\'s tag "{$tag}" got truncated as it was longer than the maximum allowed tag length(255 characters)',
    'AssetTagTruncatedWarning' => 'Tag "{$tag}" of asset "{$name}" got truncated as it was longer than the maximum allowed tag length(255 characters)',
    'JiraFilterProjectsForNewIssues' => 'Filter projects for new Issues.',
    'JiraFilterProjectsForNewIssuesInstructions' => 'Disable to create Risks for ALL new Jira Issues',
    'JiraCopyDescriptionTo' => 'Copy Description to',
    'JiraCopyDescriptionToInstructions' => 'Select which field the Jira Issue\'s Description should be copied into.',
    'JiraScanProjectsForNewIssuesIsRequired' => '"Scan Projects" field is required when filtering is turned on!',
    'JiraCreateRiskAs' => 'Create Risk as',
    'JiraCreateRiskAsInstructions' => 'Select which user will be the submitter of the created Risks',
    'JiraCreateIssueAsIsRequired' => '"Create Risk as" field is required!',
    'FixFileEncodingIssues' => 'Fix File Encoding Issues',
    'FixFileEncodingIssuesDisclaimer' => 'We have detected a possible issue with files stored in your SimpleRisk database. The table below will show you which items have corrupt file(s) and need to be corrected. Please take a look at the listed items and re-upload the affected files.',
    'AttachmentType' => 'Attachment Type',
    'FileName' => 'File Name',
    'Upload' => 'Upload',
    'YouHaveToSelectAFileToUpload' => 'You have to select a file to upload.',
    'InvalidUniqueName' => 'File Unique Name provided is Invalid!',
    'ref_type_exceptions' => 'Document Exception',
    'ref_type_documents' => 'Document',
    'ref_type_test_audit' => 'Test Audit',
    'SessionAbsoluteTimeout' => 'Session Absolute Timeout',
    'TagsWidgetPlaceholder' => 'Select/Add Tag',
    'TagType_questionnaire_answer' => 'Questionnaire Answer',
    'TagType_questionnaire_pending_risk' => 'Questionnaire Pending Risk',
    'TagType_incident_management_source' => 'Source Tag',
    'TagType_incident_management_destination' => 'Destination Tag',
    'ImportExportTagSeparatorChangeWarning' => 'The separator of individual tags changed from \' , \' (comma) to \' | \' (pipe). Please make sure that your file is using the new separator.',
    'ReportIMLessonsLearnedHelp' => 'This report shows all open lessons learned ordered by the average incident priority.',
    'Lesson' => 'Lesson',
    'NumberOfIncidents' => 'Number of Incidents',
    'PriorityAverage' => 'Priority Average',
    'FunctionalAverage' => 'Functional Average',
    'InformationAverage' => 'Information Average',
    'RecoveryAverage' => 'Recovery Average',
    'IncidentTrend' => 'Incident Trend',
    'DateRange' => 'Date Range',
    'Average' => 'Average',
    'ResolutionTarget' => 'Resolution Target (Days)',
    'Playbooks' => 'Playbooks',
    'AddNewPlaybook' => 'Add New Playbook',
    'SelectAnExistingPlaybook' => 'Select An Existing Playbook',
    'AreYouSureYouWantToDeleteThisPlaybook' => 'Are You Sure You Want To Delete This Playbook?',
    'AddPlaybookCategory' => 'Add Playbook Category',
    'AddPlaybookAction' => 'Add Playbook Action',
    'SelectExistingCategory' => 'Select Existing Category',
    'AddNewCategory' => 'Add New Category',
    'SelectExistingAction' => 'Select Existing Action',
    'AddNewAction' => 'Add New Action',
    'AreYouSureYouWantToDeleteThisPlaybookAction' => 'Are you sure you want to delete this playbook action?',
    'PlaybookAction' => 'Playbook Action',
    'PlaybookCategory' => 'Playbook Category',
    'ContainmentPlaybookCategories' => 'Containment Playbook Categories',
    'EradicationPlaybookCategories' => 'Eradication Playbook Categories',
    'RecoveryPlaybookCategories' => 'Recovery Playbook Categories',
    'Forbidden' => 'Forbidden',
    'LastTestResult' => 'Last Test Result',
    'Selected' => 'Selected',
    'Risks' => 'Risks',
    'CurrentRiskComments' => 'Current Risk Comments',
    'CommentDate' => 'Comment Date',
    'ReportRecentCommentedHelp'=>'This report shows all risks and their most recent comment',
    'UpdateExtraVersionCheck' => 'Checking Extra versions...',
    'BackupStartApplication' => 'Creating a backup of the application files.',
    'BackupStartDatabase' => 'Creating a backup of the database.',
    'ConnectivityVisualizer' => 'Connectivity Visualizer',
    'ThereAreNoConnectionsAssociatedWithTheSelectedValue' => 'There are no connections associated with the selected value',
    'InvalidSimpleriskBaseUrl' => 'Invalid SimpleRisk Base URL!',
    'Questionnaire' => 'Questionnaire',
    'FileEncodingFixHeader_risk' => 'Risk Management',
    'FileEncodingFixHeader_compliance' => 'Governance & Compliance',
    'FileEncodingFixHeader_questionnaire' => 'Assessments',
    'DaysBeforeTheReviewIsDue' => 'days before the review is due',
    'DaysAfterTheReviewIsDue' => 'days after the review is due',
    'SendAnEmailWhenTheReviewIsDue' => 'Send an email when the review is due',
    'ReviewsDueToday' => 'Reviews Due Today',
    'ReviewsPastDue' => 'Reviews Past Due',
    'ReviewsDueSoon' => 'Reviews Due Soon In {$DueDate} days',
    'Submitter' => 'Submitter',
    'ControlMaturity' => 'Control Maturity',
    'CurrentControlMaturity' => 'Current Control Maturity',
    'DesiredControlMaturity' => 'Desired Control Maturity',
    'ControlGapAnalysis' => 'Control Gap Analysis',
    'BelowMaturity' => 'Below Maturity',
    'AtMaturity' => 'At Maturity',
    'AboveMaturity' => 'Above Maturity',
    'NoAddProjectPermission' => 'You have no permission to add project.',
    'ImportUsers' => 'Import Users',
    'ExportUsers' => 'Export Users',
    'Lockout' => 'Lockout',
    'DynamicRiskReportDisplay' => 'Dynamic Risk Report Display',
    'PlanMitigationDisplay' => 'Plan Mitigation Display',
    'PerformReviewsDisplay' => 'Perform Reviews Display',
    'ReviewRegularlyDisplay' => 'Review Regularly Display',
    'UserImportFieldsRequired' => 'A username, full name and email address are required.',
    'NewUsernameAddedSuccessfully' => 'A new user with username "{$username}" was added successfully.',
    'UsernameWasUpdatedSuccessfully' => 'The user with username "${username}" was updated successfully.',
    'RiskAndThreatCatalog' => 'Risk and Threat Catalog',
    'ThreatCatalog' => 'Threat Catalog',
    'ThreatGrouping' => 'Threat Grouping',
    'Threat' => 'Threat',
    'ThreatEvent' => 'Threat Event',
    'NewThreat' => 'New Threat',
    'EditThreat' => 'Edit Threat',
    'AreYouSureYouWantToDeleteThisThreatCatalogItem' => 'Are you sure you want to delete this threat catalog item?',
    'Back' => 'Back',
    'UnableToCommunicateWithTheSimpleRiskServer' => 'Unable to Communicate with the SimpleRisk Server',
    'Fields' => 'Fields',
    'TemplateGroup' => 'Template Group',
    'AddTemplateGroup' => 'Add Template Group',
    'UpdateTemplateGroup' => 'Update Template Group',
    'AreYouSureYouWantToDeleteThisTemplateGroup' => 'Are you sure you want to delete this template group?',
    'CantDeleteDefaultTemplateGroup' => 'You can\'t delete default Template group.',
    'IncidentAddPermissionMessage' => 'You do not have permission to submit new incidents.  Any incidents that you attempt to submit will not be recorded.  Please contact an Administrator if you feel that you have received this message in error.',
    'IncidentUpdatePermissionMessage' => 'You do not have permission to modify incidents.  Any incidents that you attempt to modify will not be recorded.  Please contact an Administrator if you feel that you have received this message in error.',
    'IncidentPreparationPermissionMessage' => 'You do not have permission to select incident preparation items.  Any items that you attempt to select will not be recorded.  Please contact an Administrator if you feel that you have received this message in error.',
    'IncidentPlaybookSelectPermissionMessage' => 'You do not have permission to select an incident response playbook to determine the Containment, Eradication and Recovery steps.  Please contact an Administrator if you feel that you have received this message in error.',
    'IncidentResponseSelectPermissionMessage' => 'You do not have permission to select incident response playbook items from the Containment, Eradication and Recovery steps.  Any items that you attempt to select will not be recorded.  Please contact an Administrator if you feel that you have received this message in error.',
    'IncidentResponseEvidenceAddPermissionMessage' => 'You do not have permission to add evidence to an incident.  Any evidence added will not be recorded.  Please contact an Administrator if you feel that you have received this message in error.',
    'IncidentResponseEvidenceDeletePermissionMessage' => 'You do not have permission to delete evidence from an incident.  Please contact an Administrator if you feel that you have received this message in error.',
    'IncidentResponseNoteAddPermissionMessage' => 'You do not have permission to add notes to an incident.  Any notes added will not be recorded.  Please contact an Administrator if you feel that you have received this message in error.',
    'IncidentResponseNoteDeletePermissionMessage' => 'You do not have permission to delete notes from an incident.  Please contact an Administrator if you feel that you have received this message in error.',
    'IncidentAddLessonPermissionMessage' => 'You do not have permission to add lessons to an incident.  Please contact an Administrator if you feel that you have received this message in error.',
    'IncidentRemoveLessonPermissionMessage' => 'You do not have permission to dismiss an incident from Lessons Learned.  Please contact an Administrator if you feel that you have received this message in error.',
    'TemplateAssignment' => 'Template Assignment',
    'PleaseSelectUser' => 'Please select user',
    'AboutThisPage' => 'About This Page',
    'ProjectStatus' => 'Project Status',
    'SupportPortal' => 'Support Portal',
    'WebSupport' => 'Web Support',
    'EmailSupport' => 'Email Support',
    'PhoneSupport' => 'Phone Support',
    'NotificationTemplate' => 'Notification Template',
    'JiraUpdateDetails' => 'Jira Update Details',
    'YouNeedToSpecifyTheTemplateNameParameter' => 'You need to specify the template name parameter!',
    'QuestionsLackingAubjectEdited' => 'Questions lacking a subject were edited to not attempt to submit a blank risk subject.',
    'AdminSelfEditWarning' => 'Admin users are unable to remove their own admin permission or lock themselves out.',
    'Value' => 'Value',
    'ControlDetails' => 'Control Details',
    'CannotDeleteLastItem' => 'Cannot delete the last item.',
    'FieldChangeTemplate' => '`{$field_name}` (`{$before}` => `{$after}`)',
    'AuditLog_TestAuditReopen' => 'Audit "{$test_audit_name}"(ID: {$test_audit_id}) was reopened by user "{$user_name}".',
    'AuditLog_TestAuditClosed' => 'Audit "{$test_audit_name}"(ID: {$test_audit_id}) was closed by user "{$user_name}". Changes: {$changes}.',
    'AuditLog_TestAuditUpdated' => 'Audit "{$test_audit_name}"(ID: {$test_audit_id}) was updated by user "{$user_name}". Changes: {$changes}.',
    'AuditLog_TestUpdated' => 'Test "{$test_name}"(ID: {$test_id}) was updated by user "{$user_name}". Changes: {$changes}.',
    'RiskScoringColumns' => 'Risk Scoring Columns',
    'InherentRiskCurrent' => 'Inherent Risk (Current)',
    'ResidualRiskCurrent' => 'Residual Risk (Current)',
    'InherentRiskDays' => 'Inherent Risk ({$days} Days)',
    'ResidualRiskDays' => 'Residual Risk ({$days} Days)',
    'Classic' => 'Classic',
    'AccessVector' => 'Access Vector',
    'AccessComplexity' => 'Access Complexity',
    'MaturityAudit' => 'Maturity Audit',
    'DefaultCurrentMaturity' => 'Default Current Maturity',
    'DefaultDesiredMaturity' => 'Default Desired Maturity',
    'ComplianceAssessment' => 'Compliance Assessment',
    'MaturityAssessment' => 'Maturity Assessment',
    'FileAttachment' => 'File Attachment',
    'QuestionLogic' => 'Question Logic',
    'QuestionnaireResponses' => 'Questionnaire Responses',
    'ContributingImpact' => 'Contributing Impact',
    'Share' => 'Share',
    'ShareResults' => 'Share Results',
    'StopSharingResults' => 'Stop Sharing',
    'AreYouSureYouWantToStopSharingThisResult' => 'Are you sure you want to stop sharing this result?',
    'ShareResultsWith' => 'Share Results With',
    'QuestionnaireResultShareContactsRequired' => 'Share Contacts are required!',
    'QuestionnaireResultShareGetContactFailed' => 'Failed to get contact info!',
    'QuestionnaireResultShareSuccessful' => 'Questionnaire result is successfully shared with the selected contacts',
    'QuestionnaireResultStopSharingSuccessful' => 'Successfully stopped sharing the questionnaire result',
    'AssessmentContact' => 'Assessment Contact',
    'User' => 'User',
    'QuestionnaireResultShareAuditLog' => 'User "{$user_name}" shared questionnaire "{$questionnaire_name}"(sent to contact "{$contact_name}" on "{$date}") result with comment "{$comment}". Shared with "{$shared_with_contacts}".',
    'QuestionnaireResultStopSharingAuditLog' => 'User "{$user_name}" stopped sharing questionnaire "{$questionnaire_name}"(sent to contact "{$contact_name}" on "{$date}") result. Stopped sharing with "{$stopped_sharing_with_contacts}".',
    'QuestionnaireResultShareOpenedAuditLog' => 'Shared questionnaire "{$questionnaire_name}"(sent to contact "{$contact_name}" on "{$date}", shared with "{$shared_with_contact_name}") result was opened.',
    'Pending' => 'Pending',
    'PasswordResetRequestsExceeded' => 'A password reset has already been requested for this user.  Please wait 10 minutes before requesting another password reset.',
    'Backups' => 'Backups',
    'AutomaticallyBackupThisSimpleRiskInstance' => 'Automatically backup this simplerisk instance',
    'BackupSchedule' => 'Backup Schedule',
    'Hourly' => 'Hourly',
    'RemoveBackupsAfter' => 'Remove backups after',
    'AnswerOrdering' => 'Answer Ordering',
    'BackupDate' => 'Backup Date',
    'ApplicationBackup' => 'Application Backup',
    'DatabaseBackup' => 'Database Backup',
    'Download' => 'Download',
    'ForSecurityReasonsBackupOutsideWebRoot' => 'For security reasons, your backups should be located outside of your web root.',
    'PrivateTmpMessage' => 'Note: If PrivateTmp is enabled, you will be unable to download backups located under the system tmp directory.',
    'SaveAndBackupNow' => 'Save and Backup Now',
    'BackupSettingsUpdated' => 'Backup settings were updated by user "{$user_name}".',
    'BackupInitiatedByUser' => 'Backup initiated by user "{$user_name}".',
    'BackupInitiated' => 'Backup initiated. This can take several minutes to complete.',
    'NoControlsAvailable' => 'No Controls Available',
    'AdminCantDisableItself' => 'An admin can\'t disable itself.',
    'AdminCantDeleteItself' => 'An admin can\'t delete itself.',
    'NoFrameworksFromGithub' => 'There is no specified frameworks imported from github',
    'AllowDocumentOwnerToSeeDocuments' => 'Allow Document Owner to See Documents',
    'AllowApproverToSeeDocuments' => 'Allow Approver to See Documents',
    'AllowAdditionalStakeholdersToSeeDocuments' => 'Allow Additional Stakeholders to See Documents',
    'AllowAllUsersToSeeDocumentsNotAssignedToTeam' => 'Allow all users to see documents not assigned to a team',
    'AllowAllUsersToSeeAllDocuments' => 'Allow All Users to See All Documents',
    'AllowAllUsersToSeeAssetsNotAssignedToTeam' => 'Allow all users to see assets not assigned to a team',
    'AssociatedRisks' => 'Associated Risks',
    'ThreatMapping' => 'Threat Mapping',
    'jQueryDeliveryMethod' => 'jQuery Delivery method',
    'AuditLog_DocumentUpdates' => 'Document "{$document_name}"(ID: {$document_id}) was updated by "{$user_name}". Changes: {$changes}.',
    'DocumentStatus' => 'Document Status',
    'UnassignedColumns' => 'Unassigned Columns',
    'RiskMappingColumns' => 'Risk Mapping Columns',
    'ExceptionStatus' => 'Exception Status',
    'ControlRisk' => 'Control Risk',
    'VulnerabilityManagementExtra' => 'Vulnerability Management Extra',
    'VulnerabilityManagement' => 'Vulnerability Management',
    'Setup' => 'Setup',
    'Triage' => 'Triage',
    'AutomaticallyUpdateVMDetails' => 'Automatically update from VM platforms',
    'SaveAndRunNow' => 'Save and Run Now',
    'ImportVulnerabilitiesByScore' => 'Automatically import vulnerabilities with a score greater than or equal to',
    'TriageVulnerabilitiesByScore' => 'Automatically triage vulnerabilities with a score greater than or equal to',
    'UploadArtifact' => 'Upload Artifact',
    'ControlType' => 'Control Type',
    'ControlStatus' => 'Control Status',
    'HighestInherentRisk' => 'Highest Inherent Risk',
    'AverageInherentRisk' => 'Average Inherent Risk',
    'HighestResidualRisk' => 'Highest Residual Risk',
    'AverageResidualRisk' => 'Average Residual Risk',
    'UpdateProjectName' => 'Update Project Name',
    'UpdatedSuccess' => 'Updated Successfully',
    'Vulnerabilities' => 'Vulnerabilities',
    'TriageVulnerabilities' => 'Triage Vulnerabilities',
    'DueDate' => 'Due Date',
    'Consultant' => 'Consultant',
    'BusinessOwner' => 'Business Owner',
    'DataClassification' => 'Data Classification',
    'NewProject' => 'New Project',
    'EditProject' => 'Edit Project',
    'ExistingRisk' => 'Existing Risk',
    'AvailableRisks' => 'Available Risks',
    'WouldYouLikeToAssociateThisFailedTestResultWithARisk' => 'Would you like to associate this failed test result with a risk?',
    'WouldYouLikeToCloseAllRisksAssociatedWithThisTest' => 'Would you like to close all risks associated with this test?',
    'RiskDetails' => 'Risk Details',
    'TagType_questionnaire_risk' => 'Questionnaire Risk',
    'SAMLRoleMapping' => 'SAML Role Mapping',
    'SAMLTeamMapping' => 'SAML Team Mapping',
    'RemoteSAMLRolePlaceholder' => 'Select a remote Role or add a new one',
    'RemoteSAMLTeamPlaceholder' => 'Select a remote Team or add a new one',
    'MappingSuccessfullyUpdated' => 'Mapping Successfully Updated!',
    'BusinessUnit' => 'Business Unit',
    'UserUpdatedAuditLog' => 'User "{$username}" was updated by "{$updater}". Changes: {$changes}.',
    'UserUpdatedFromidPDataAuditLog' => 'User "{$username}" was updated with the new data received from the idP. Changes: {$changes}.',
    'UpdateUserWithDataFromTheIdP' => 'Update user with data from the idP',
    'LDAPRoleMapping' => 'LDAP Role Mapping',
    'LDAPTeamMapping' => 'LDAP Group Mapping',
    'RemoteLDAPRolePlaceholder' => 'Select a remote Role or add a new one',
    'RemoteLDAPTeamPlaceholder' => 'Select a remote Group or add a new one',
    'MapTeamToLDAPGroup' => 'Map Teams to LDAP Groups',
    'RemoteMappingDuplicationError' => 'Remote mapping contains a duplicate',
    'LDAPFailedToRefreshGroups' => 'Failed to refresh LDAP Groups',
    'ManageStoredRemoteItems' => 'Manage Stored Remote Items',
    'SAMLTeam' => 'SAML Team',
    'SAMLRole' => 'SAML Role',
    'LDAPGroup' => 'LDAPGroup',
    'LDAPUserFilterInstructions' => 'Please make sure that your filter is utilizing the %username% variable. That will be used for including the username in the filter when looking for the user on the server. Saving the filter as empty will set it to its default value.',
    'LogoutFromRemoteSessions' => 'Logout terminates SimpleRisk session AND logs user out of the SAML Identity Provider (IdP)',
    'SAMLLogoutSuccessful' => 'You have been logged out from your SAML session.',
    'SAMLLogoutFailed' => 'We were unable to log you out of all your sessions. To be completely sure that you are logged out, you need to close your web browser.',
    'SpecifiedNameAlreadyInUse' => 'The specified name is already in use.',
    'MaximumRiskSubjectLength' => 'Maximum Risk Subject Length',
    'RiskSubjectTruncated' => 'Risk subject was too long and got truncated to {$limit} characters.',
    'BootstrapDeliveryMethod' => 'Bootstrap Delivery Method',
    'TestAuditDoesNotExist' => 'Test Audit Does Not Exist',
    'QuestionnaireEmailTemplate' => 'Questionnaire Email Template',
    'QuestionnaireCompletionEmailTemplate' => 'Questionnaire Completion Email Template',
    'QuestionnaireResultRejectEmailTemplate' => 'Questionnaire Result Reject Email Template',
    'QuestionnaireResultShareEmailTemplate' => 'Questionnaire Result Share Email Template',
    'AnswerPlaceholder' => 'Add an answer',
    'QuestionPlaceholder' => 'Add a question',
    'NoFileAttached' => 'No file attached',
    'NoDataToUpdate' => 'No data to update',
    'SelectedQuestions' => 'Selected Questions',
    'CreateTabs' => 'Create Tabs',
    'Previous' => 'Previous',
    'DisableTabs' => 'Disable Tabs',
    'NoPermissionForThisSelection' => 'You have no permission to access this Saved Selection!',
    'SelectionSaveFailed' => 'Selection save failed!',
    'Logs' => 'Logs',
    'NoGroup' => 'No Group',
    'InvalidGroups' => 'Invalid groups!',
    'OrderUpdatedSuccessfully' => 'The order was updated successfully.',
    'CantDeleteTheDefaultRiskGrouping' => 'Can\'t Delete The Default Risk Grouping',
    'CantDeleteTheDefaultThreatGrouping' => 'Can\'t Delete The Default Threat Grouping',
    'ThreatGroupings' => 'Threat Groupings',
    'RiskCatalogDropdownPlaceholder' => 'Select a risk mapping or start typing to search',
    'ThreatCatalogDropdownPlaceholder' => 'Select a threat mapping or start typing to search',
    'UserDropdownPlaceholder' => 'Select a user or start typing to search',
    'GraphicalRiskAnalysis' => 'Graphical Risk Analysis',
    'ResetMitigations' => 'Reset Mitigations',
    'ResetReviews' => 'Reset Reviews',
	'EnableEncryptionDebugLogging' => 'Enable Encrypted Database Extra debug logging',
    'Log' => 'Log',
    'Date' => 'Date',
    'Platform' => 'Platform',
    'NotifyOnNewDocument' => 'Notify on New Document',
    'NotifyOnDocumentUpdate' => 'Notify on Document Update',
    'AuditLog_DocumentCreate' => 'A new document named "{$document_name}" was created by user "{$user_name}".',
    'UpdatedBy'=>'Updated By',
    'AllowTeamToSeeDocuments'=>'Allow Team to See Documents',
    'AllowDocumentOwnersManagerToSeeDocuments' => 'Allow Document Owner\'s Manager to See Documents',
    'RisksAndIssues'=>'Risks and Issues',
    'RiskTags' => 'Risk Tags',
    'Trend' => 'Trend',
    'Increasing' => 'Increasing',
    'Decreasing' => 'Decreasing',
    'NoChange' => 'No Change',
    'Visualization' => 'Visualization',
    'AreaRange' => 'Area Range',
    'Line' => 'Line',
    'Bar' => 'Bar',
    'Title' => 'Title',
    'Y-Axis' => 'Y-Axis',
    'Y-AxisValue' => 'Y-Axis Value',
    'X-Axis' => 'X-Axis',
    'X-AxisValue' => 'X-Axis Value',
    'Aggregation' => 'Aggregation',
    'CustomLabel' => 'Custom Label',
    'Count' => 'Count',
    'CountTotal' => 'Count Total',
    'Max' => 'Max',
    'Min' => 'Min',
    'TimeDays' => 'Time (Days)',
    'TimeWeeks' => 'Time (Weeks)',
    'TimeMonths' => 'Time (Months)',
    'TimeYears' => 'Time (Years)',
    'GenerateReport' => 'Generate Report',
    'MappedControlNumbers' => 'Mapped Control Numbers',
    'TagType_test' => 'Test',
    'TagType_test_audit' => 'Test Audit',
    'Continue' => 'Continue',
    'AddTagsToTestAudit' => 'Add Tags To Test Audit',
    'RisksAndIssuesDisplay' => 'Risks And Issues Display',
    'ExportToXLSByClickingBelow' => 'Export to a XLS file by clicking below',
    'ExportToXLSXByClickingBelow' => 'Export to a XLSX file by clicking below',
    'ImportCsvXlsXlsxFile' => 'Import the following CSV or XLS/XLSX file into SimpleRisk',
    'Notifications' => 'Notifications',
    'IncidentManagementNotification_SectionHeader_new' => 'Notify on New Incident',
    'IncidentManagementNotification_SectionHeader_status_changed' => 'Notify on Status change',
    'IncidentManagementNotification_SectionHeader_summary_changed' => 'Notify on Summary change',
    'IncidentManagementNotification_SectionHeader_playbook_changed' => 'Notify on Playbook change',
    'IncidentManagementNotification_SectionHeader_details_changed' => 'Notify on Details change',
    'IncidentManagementNotification_SectionHeader_all_containment_steps_completed' => 'Notify on all Containment steps completed',
    'IncidentManagementNotification_SectionHeader_all_eradication_steps_completed' => 'Notify on all Eradication steps completed',
    'IncidentManagementNotification_SectionHeader_all_recovery_steps_completed' => 'Notify on all Recovery steps completed',
    'IncidentManagementNotification_SectionHeader_evidence_attached' => 'Notify on Evidence attached',
    'IncidentManagementNotification_SectionHeader_notes_added' => 'Notify on Notes added',
    'IncidentManagementNotification_SectionHeader_lesson_learned_added' => 'Notify on Lessons Learned added',
    'IncidentManagementNotification_Notify_reporter' => 'Notify Reporter',
    'IncidentManagementNotification_Notify_owner' => 'Notify Owner',
    'IncidentManagementNotification_Notify_additional_stakeholders' => 'Notify Additional Stakeholders',
    'IncidentManagementNotification_Notify_team' => 'Notify Team',
    'IncidentManagementNotification_EmailSubject_new' => 'New incident reported',
    'IncidentManagementNotification_EmailSubject_status_changed' => 'Incident status changed',
    'IncidentManagementNotification_EmailSubject_summary_changed' => 'Incident Summary changed',
    'IncidentManagementNotification_EmailSubject_playbook_changed' => 'Incident playbook changed',
    'IncidentManagementNotification_EmailSubject_details_changed' => 'Incident details changed',
    'IncidentManagementNotification_EmailSubject_all_containment_steps_completed' => 'All incident containment steps completed',
    'IncidentManagementNotification_EmailSubject_all_eradication_steps_completed' => 'All incident eradication steps completed',
    'IncidentManagementNotification_EmailSubject_all_recovery_steps_completed' => 'All incident recovery steps completed',
    'IncidentManagementNotification_EmailSubject_evidence_attached' => 'New evidence added to incident',
    'IncidentManagementNotification_EmailSubject_notes_added' => 'New note added to incident',
    'IncidentManagementNotification_EmailSubject_lesson_learned_added' => 'New lesson learned added to incident',
    'NotSpecified' => 'Not Specified',
    'IncidentSummaryUpdateFailed_empty' => 'The summary of an incident cannot be empty.',
    'IncidentSummaryUpdateSuccessful' => 'Summary successfully updated.',
    'ImportSuccessful' => 'Import Successful!',
    'Document' => 'Document',
    'SelfAssessments' => 'Self Assessments',
    'AssetId'=>'Asset ID',
    'ExportTemplateGroups' => 'Export Template Groups',
    'ImportTemplateGroups' => 'Import Template Groups',
    'TemplateGroupID' => 'Template Group ID',
    'TemplateGroupName' => 'Template Group Name',
    'ExportControlTests' => 'Export Control Tests',
    'ImportControlTests' => 'Import Control Tests',
    'TestID' => 'Test ID',
    'IDNoEXitFailedToUpdate' => 'ID $id doesn\'t exist, so it is has not been imported or updated',
    'InvalidUsernameOrPassword' => 'Invalid username or password.',
    'InvalidUsernameOrPasswordCaseSensitive' => 'Invalid username or password. (Note: Both usernames and passwords are case sensitive.)',
    'SSLSecurityCheckWarning' => 'WARNING: SSL prevents MITM attacks and disabling the following options is a security concern',
    'EnableSSLCertificateCheckSimpleRisk' => 'Enable SSL Certificate Checks for SimpleRisk API Requests',
    'EnableSSLCertificateCheckExternal' => 'Enable SSL Certificate Checks for External Websites',
    'EnableSSLCertificateCheckVM' => 'Enable SSL Certificate Checks for Vulnerability Management',
    'DuoToopherRemoved' => 'Duo is longer supported by SimpleRisk directly. Instead, we have migrated to a generic TOTP authenticator. Please set up your new authenticator below.',
    'ProtectYourSimpleRiskAccount' => 'Protect Your SimpleRisk Account',
    '2FADescription' => 'Two-factor authentication enhances the security of your account by using a secondary device to verify your identity. This prevents anyone but you from accessing your account, even if they know your password.',
    '2FAStep1' => 'Step 1 - Scan the code below with a 2FA app such as Google Authenticator',
    '2FAStep2' => 'Step 2 - Enter the code from your 2FA app below to verify',
    'YourSimpleRiskAccountIsProtected' => 'Your SimpleRisk Account is protected with MFA.',
    'ToDisableMFA' => 'To disable MFA, verify your current MFA token and click the Disable button.',
    'MFAToken' => "MFA Token",
    'RequireMFAForAllUsers' => 'Require MFA for all users',
    'MFARequiredForAllusers' => 'MFA is required for all users and can only be disabled by an admin.',
    'MFADisabledSuccessfully' => 'MFA has been successfully disabled on your account',
    'MFAEnabledSuccessfully' => 'MFA has been successfully enabled on your account',
    'VerifyItsYou' => 'Verify its you by providing your MFA token below:',
    'MFAVerificationFailed' => 'MFA Verification Failed',
    'EnableMFA' => 'Enable MFA',
    'DisableMFA' => 'Disable MFA',
    'SelectionSaveSuccessful' => 'Selection successfully saved',
    'AssetVerifiedLog' => 'Asset "{$name}" was verified by user "{$user}".',
    'AssetDeletedLog' => 'Asset "{$name}" was deleted by user "{$user}".',
    'AssetDiscardedLog' => 'Asset "{$name}" was discarded by user "{$user}".',
    'ConfirmVerifyAllAssets' => 'Are you sure you want to verify every unverified assets?',
    'ConfirmDiscardAllAssets' => 'Are you sure you want to discard every unverified assets?',
    'ConfirmDeleteAllAssets' => 'Are you sure you want to delete every verified assets?',
    'EditFailed_NoPermission' => 'Edit failed, no permission.',
    'EditFailed_FieldMustBeUnique' => 'Edit failed, value of field "{$field}" must be unique.',
    'EditFailed_NotSelected' => 'Edit failed, field is not selected on the UI.',
    'EditFailed_IncorrectOrEmptyRequiredFields' => 'Edit failed, incorrect or empty required fields.',
    'EditFailed_RequiredFieldEmpty' => 'Edit failed, required field "{$field}" can\'t be empty.',
    'EditFailed_FieldNotEditable' => 'Edit failed, field "{$field}" can\'t be edited.',
    'EditFailed_CustomFieldNeedsCustomization' => 'Edit failed, custom fields can only be edited when the Customization extra is activated.',
    'EditFailed_InvalidView' => 'Edit failed, invalid view requested.',
    'FieldUpdated_asset' => 'Field "{$fieldName}" of asset "{$name}" was updated by user "{$user}".',
    'UpdateSuccess_asset' => 'Asset "{$name}" was successfully updated by user "{$user}".',
    'AreYouSureYouWantToDeactivateThisExtra' => 'Are You Sure You Want to Deactivate This Extra?',
    'Abort' => 'Abort',
    'EnablingSelectedSCFMessage' => 'Enabling the selected Secure Controls Framework (SCF) frameworks. This can take several seconds to complete.',
    'DisablingSelectedSCFMessage' => 'Disabling the selected Secure Controls Framework (SCF) frameworks.',
    'AssetAssetGroupWidgetPlaceholder' => 'Select an Asset or Asset Group',
    'AssetAssetGroupWidgetOnlyNewPlaceholder' => 'Add an Asset name',
    'AssetAssetGroupWidgetInstructions' => 'Select an Asset or Asset Group. You can create a new Asset by adding its name to the list.',
    'UpdateComplianceForgeSCF' => 'Update Secure Controls Framework (SCF) Framework',
    'MappedAssets' => 'Mapped Assets',
    'AddControl' => 'Add Control',
    'CurrentMaturity' => 'Current Maturity',
    'AddDocument' => 'Add Document',
    'EditDocument' => 'Edit Document',
    'EncodingIssueCountUpdated' => 'Encoding issue count has been updated for type "{$type}": {$old_count} -> {$count}.',
    'EncodingIssueCleanedUp' => 'Encoding issues are cleaned up for type "{$type}".',
    'RejectedRisk' => 'Rejected Risk',
    'DeletedRisk' => 'Deleted Risk',
    'ClosedRisk' => 'Closed Risk',
    'AllClosedRisksFromQuestionnaires' => 'All Closed Risks from Questionnaires',
    'AllDeletedRisksFromQuestionnaires' => 'All Deleted Risks from Questionnaires',
    'MultipleChoice_SingleSelect' => 'Multiple Choice (Single-Select)',
    'MultipleChoice_MultiSelect' => 'Multiple Choice (Multi-Select)',
    'APIDocumentation' => 'API Documentation',
    'ReviewedBy' => 'Reviewed by',
    'LimitedTestmailMessage' => 'A Test email has been sent recently. You must wait 5 minutes before another test email may be sent.',
    'AutomaticallySendAssessmentResults' => 'Automatically send assessment results to all assessment contacts upon completion.',
    'ResendAssessment' => 'Schedule and send this assessment every {$day} days.',
    'NotifyNotCompleteAssessment' => 'Notify assessment contacts every {$day} days until completed.',
    'QuestionnaireNotCompleteEmailTemplate' => 'Questionnaire Not Completed Email Template',
    'RiskAssessmentQuestionnaireNotCompleted' => 'Risk Assessment Questionnaire Not Completed',
    'SaveAndSend' => 'Save & Send',
    'NoPermissionForAddAssessmentContacts' => 'You don\'t have permission to Add Assessment Contacts',
    'NoPermissionForEditAssessmentContacts' => 'You don\'t have permission to Edit Assessment Contacts',
    'NoPermissionForDeleteAssessmentContacts' => 'You don\'t have permission to Delete Assessment Contacts',
    'NoPermissionForAddAssessmentQuestions' => 'You don\'t have permission to Add Assessment Questions',
    'NoPermissionForEditAssessmentQuestions' => 'You don\'t have permission to Edit Assessment Questions',
    'NoPermissionForDeleteAssessmentQuestions' => 'You don\'t have permission to Delete Assessment Questions',
    'NoPermissionForAddQuestionnaireTemplates' => 'You don\'t have permission to Add Questionnaire Templates',
    'NoPermissionForEditQuestionnaireTemplates' => 'You don\'t have permission to Edit Questionnaire Templates',
    'NoPermissionForDeleteQuestionnaireTemplates' => 'You don\'t have permission to Delete Questionnaire Templates',
    'NoPermissionForAddQuestionnaires' => 'You don\'t have permission to Add Questionnaires',
    'NoPermissionForEditQuestionnaires' => 'You don\'t have permission to Edit Questionnaires',
    'NoPermissionForDeleteQuestionnaires' => 'You don\'t have permission to Delete Questionnaires',
    'NoPermissionForSendQuestionnaires' => 'You don\'t have permission to Send Questionnaires',
    'datatables_ShowAll' => 'Show All',
    'datatables_ShowLess' => 'Show Less',
    'Confirmation' => 'Confirmation',
    'MissingUser' => 'Missing User',
    'UserResponsibilitiesCannotBeEditedWhenUserIsAnAdmin' => 'User responsibilities cannot be edited when the user is an admin.',
    'UserResponsibilitiesCannotBeEditedWhenUserIsGoingToBeAnAdmin' => 'User responsibilities cannot be edited when the user is going to be an admin.',
    'EditRole' => 'Edit Role',
    'Connectivity' => 'Connectivity',
    'HealthCheckSummary' => 'Health Check Summary',
    'SimpleRiskVersion' => 'SimpleRisk Version',
    'Configurations' => 'Configurations',
    'FileAndDirectoryPermissions' => 'File and Directory Permissions',
    'SimpleRiskCore' => 'SimpleRisk Core',
    'DeleteSelectedControls' => 'Delete Selected Controls',
    'CreateControl' => 'Create Control',
    'AddMapping' => 'Add Mapping',
    'CreateSuccess_asset' => 'Asset "{$name}" was successfully created by user "{$user}".',
    'AreYouSureYouWantToDeleteTheSelectedControls' => 'Are you sure you want to delete the selected control(s)?',
    'ControlMappedToDifferentMaturitiesOnAsset' =>'A control is mapped to different maturities on the same asset',
    'Advanced_Search_no_results_1' => 'There appears to be no results for your query.',
    'Advanced_Search_no_results_2' => 'Double check your search for any typos, spelling errors or try a different search term.',
    'IncidentsPerDay' => 'Incidents Per Day',
    'CurrentVsDesiredMaturity' => 'Current vs Desired Maturity by Control Family',
    'RiskDistribution' => 'Risk Distribution',
    'RiskDistributionDescription'=>'The above pie charts help to show the distribution of risks amongst the various risk levels for both inherent and residual risk.  We can use these two pies to show progress in our risk mitigation efforts.  If the Residual Risk pie shows large slices of very high or high risks it can be a sign that your organization is taking on too much risk and further mitigation efforts are required.',
    'EnableTabs' => 'Enable Tabs',
    'NewTab' => 'New Tab',
    'SearchForFramework' => 'Search for Framework',
    'SearchForControl' => 'Search for Control',
    'SelectedOnAnotherTab' => 'Selected on another tab',
    'ConfirmDisableTabbedExperience' => 'You\'re about to disable the tabbed experience for this template. This will move all the questions from the tabs to a single list. Are you sure you want to continue?',
    'ConfirmDeleteTab' => 'Are you sure you want to delete this tab with all the questions on it?',
    'GenericDeleteItemConfirmation' => 'Are you sure you want to delete the selected items?',
    'ConfirmDeletePendingRisk' => 'Are you sure you want to delete the selected items?',
    'Display' => 'Display',
    'ShowAssociationData' => 'Show Association Data',
    'Association' => 'Association',
    'InstanceDetails' => 'Instance Details',
    'PendingResponse' => 'Pending Response',
    'PendingReview' => 'Pending Review',
    'Rejected' => 'Rejected',
    'NotApproved' => 'Not Approved',
    'AreYouSureYouWantToSetThisResultToNotApproved' => 'Are you sure you want to set this result to Not Approved?',
    'QuestionnaireResultNotApprovedAuditLog' => 'Questionnaire "{$questionnaire_name}"(sent to contact "{$contact_name}" on "{$date}") result was marked as not approved by user "{$user_name}".',
    'QuestionnaireResultNotApprovedSuccessfully' => 'Questionnaire result successfully marked as not approved.',
    'QuestionnaireResultRejectedMessage' => 'Rejected by {$user} on {$timestamp}.',
    'QuestionnaireResultNotApprovedMessage' => 'Marked as not approved by {$user} on {$timestamp}.',
    'QuestionnaireStatus' => 'Questionnaire Status',
    'ReviewStatus' => 'Review Status',
    'QuestionnaireResultsHelp' => 'Below is the list of questionnaire results',
    'QuestionnaireColumns' => 'Questionnaire Columns',
    'ContactColumns' => 'Contact Columns',
    'LastComment' => 'Last Comment',
    'MFAReset' => 'Multifactor Authentication (MFA) Reset',
    'PerformMFAResetForUser' => 'Perform a MFA reset for user',
    'ResetMFA' => 'Reset MFA',
    'MFANotEnabledForUser' => 'MFA is Not Enabled for the Selected User',
    'MFAResetSuccessful' => 'The MFA reset was successful',
    'First' => 'First',
    'Last' => 'Last',
    'AnthropicConnectionSuccess' => 'Successfully connected to the Anthropic API.',
    'AnthropicConnectionWarning' => 'Invalid credentials! Unable to connect to Anthropic with the API key.',
    'ResetAPIKey' => 'Reset API Key',
    'ArtificialIntelligence' => 'Artificial Intelligence',
    'ArtificialIntelligenceAdditionalContext' => 'Artificial Intelligence Additional Context',
    'ArtificialIntelligenceAdditionalContextDescription' => 'The following information is optional, but will provide the artificial intelligence with the additional context which it needs to provide more meaningful results. All information entered below WILL BE SENT TO ANTHROPIC for analysis in their LLM in order to provide you with results tailored to your organization.',
    'OrganizationContext' => 'Organization Context',
    'DataContext' => 'Data Context',
    'MaturityContext' => 'Maturity Context',
    'ImplementationContext' => 'Implementation Context',
    'Recommendations' => 'Recommendations',
    'Question#' => 'Question #',
    'DownloadAsXLSX' => 'Download as XLSX',
    'UserResponsibilitiesAndTeamsCannotBeEditedWhenTheUserIsGoingToBeAnAdmin' => 'User responsibilities and teams cannot be edited when the the user is going to be an admin.',
    'UserResponsibilitiesAndTeamsCannotBeEditedWhenTheUserIsAnAdmin' => 'User responsibilities and teams cannot be edited when the the user is an admin.',
    'FileUploadInvalidParameters' => 'File Upload Failed: Invalid Parameters',
    'FileUploadNoFileSent' => 'File Upload Failed: No File Sent',
    'FileUploadExceededFileSize' => 'File Upload Failed: Exceeded Filesize Limit',
    'FileUploadUnknownErrors' => 'File Upload Failed: Unknown Errors',
    'DynamicIncidentReport' => 'Dynamic Incident Report',
    'FilteringSelections' => 'Filtering Selections',
    'ProcessingPleaseWait' => 'Processing. Please wait!',
    'PleaseEnterAValidPhoneNumber' => 'Please enter a valid phone number',
    'TheNameOfAPlaybookActionCannotBeEmpty' => 'The name of a playbook action cannot be empty.',
    'InvalidWidgetName' => 'Invalid widget name',
    'EditMode' => 'Edit Mode',
    'On' => 'On',
    'Off' => 'Off',
    'SelectWidgetToAdd' => 'Select a widget to add',
    'DragToAddSelectedWidget' => 'Drag to add the selected widget!',
    'DropHereToRemoveWidget' => 'Drop here to remove widget!',
    'EditModeInformation' => 'Turn on Edit Mode edit the layout. Turning it off won\'t automatically save the layout.',
    'InvalidLayout' => 'Invalid Layout!',
    'InvalidLayoutOnlyCustomAllowedAsDefault' => 'Invalid Layout! Only custom layouts can be saved as default.',
    'LayoutSaved' => 'Layout Saved!',
    'DefaultLayout' => 'Default Layout',
    'DefaultLayoutInformation' => 'Sets this layout as the default, to be used instead of the one provided by SimpleRisk for users who doesn\'t have a custom layout set. You can only set a saved non-empty custom layout as default. If a layout marked as default gets restored to the default layout, it will restore it to the default provided by SimpleRisk.',
    'LayoutDefaultStatusUpdated' => 'The layout\'s default status has been updated.',
    'RestoreDefaultLayout' => 'Restore default layout',
    'RestoreSavedLayout' => 'Restore saved layout',
    'DefaultLayoutRestored' => 'Default layout has been successfully restored!',
    'SavedLayoutRestored' => 'Saved layout has been successfully restored!',
    'ConfirmRestoreLayout' => 'Are you sure? You will lose your changes made to this layout.',
    'ConfirmDisableEditModeWithPendingChanges' => 'You have unsaved changes that you will lose on leaving the page. Are you sure you want to disable \'Edit Mode\' and potentially forget about saving your changes?',
    'ConfirmSave' => 'Saving these changes will overwrite your previously saved layout. Are you sure you want to continue?',
    'ConfirmSaveAdminDefault' => 'This layout is set as the default for this layout type. Saving these changes will change the layout for all users who don\'t have a custom layout set for this layout type. Are you sure you want to continue?',
    'RisksByMonth' => 'Risks by Month',
    'WidgetType_chart' => 'Chart',
    'WidgetType_table' => 'Table',
    'WidgetType_WYSIWYG' => 'WYSIWYG',
    'EnableAIAssistanceForRiskData' => 'Enable AI assistance for risk data (Data will be sent to Anthropic using your API key)',
    'ArtificialIntelligenceAssistant' => 'Artificial Intelligence Assistant',
    'LastUpdated' => 'Last Updated',
    'RichText' => 'Rich Text',
    'CreateCustomWidget' => 'Create a custom widget',
    'SelectCustomWidgetType' => 'Select custom widget type',
    'InvalidDataPleaseContactAdministrator' => 'Invalid Data! Please contact an Administrator.',
    'EditWidgetText' => 'Edit Widget Text',
    'UnauthorizedAccessInAPI' => 'Unauthorized Access.  The authenticated user does not have proper permissions.',
    'FAIRRiskAssessment' => 'FAIR Risk Assessment',
    'RiskScenario' => 'Risk Scenario',
    'Assumptions' => 'Assumptions',
    'MonteCarloSimulation' => 'Monte Carlo Simulation',
    'ContactFrequency' => 'Contact Frequency',
    'ProbabilityOfAction' => 'Probability of Action',
    'ThreatCapability' => 'Threat Capability',
    'ResistanceStrength' => 'Resistance Strength',
    'ThreatEventFrequency' => 'Threat Event Frequency',
    'Vulnerability' => 'Vulnerability',
    'LossEventFrequency' => 'Loss Event Frequency',
    'PrimaryLoss' => 'Primary Loss',
    'SecondaryLossEventFrequency' => 'Secondary Loss Event Frequency',
    'SecondaryLossMagnitude' => 'Secondary Loss Magnitude',
    'Productivity' => 'Productivity',
    'Response' => 'Response',
    'Replacement' => 'Replacement',
    'CompetitiveAdvantage' => 'Competitive Advantage',
    'FinesAndJudgements' => 'Fines and Judgements',
    'Reputation' => 'Reputation',
    'SecondaryRisk' => 'Secondary Risk',
    'LossMagnitude' => 'Loss Magnitude',
    'AnnualLossExposure' => 'Annual Loss Exposure',
    'Documentation' => 'Documentation',
    'EnableAIAssistanceForDocumentData' => 'Enable AI assistance for document data (Data will be sent to Anthropic using your API key)',
    'ExtraTechnicalToggledOn' => 'The extra "{$extra_name}" was toggled on by a technical user.',
    'ExtraTechnicalToggledOff' => 'The extra "{$extra_name}" was toggled off by a technical user.',
    'ANewRiskCatalogItemWasAddedSuccessfully' => 'A new risk catalog item was added successfully.',
    'ANewThreatCatalogItemWasAddedSuccessfully' => 'A new threat catalog item was added successfully.',
    'AnExistingRiskCatalogItemWasUpdatedSuccessfully' => 'An existing risk catalog item was updated successfully.',
    'AnExistingThreatCatalogItemWasUpdatedSuccessfully' => 'An existing threat catalog item was updated successfully.',
    'TheDataIDWasNotAValidValue' => 'The data ID was not a valid value.  Please try again.',
    'DynamicAuditReport' => 'Dynamic Audit Report',
    'PleaseSelectAtLeastOneAssessmentToDelete' => 'Please select at least one assessment to delete',
    'PleaseSelectAtLeastOneRiskToDelete' => 'Please select at least one risk to delete',
    'AnExistingRiskCatalogItemWasDeletedSuccessfully' => 'An existing risk catalog item was deleted successfully',
    'AnExistingThreatCatalogItemWasDeletedSuccessfully' => 'An existing threat catalog item was deleted successfully',
    'NewAsset' => 'New Asset',
    'NewAssetGroup' => 'New Asset Group',
    'PleaseSelectAtLeastOneColumn' => 'Please select at least one column',
    'IncidentWasDismissedFromLessonsLearned' => 'Incident was dismissed from lessons learned',
    'NewEvidenceWasAddedSuccessfully' => 'New evidence was added successfully.',
    'ANewPlaybookWasAddedSuccessfully' => 'A new playbook was added successfully.',
    'PlaybookNameExists'=>'The playbook name already exists.',
    'TheNameOfThePlaybookActionAlreadyExists' => 'The name of the playbook action already exists.',
    'UsernameCannotBeEmpty' => 'Username cannot be empty.',
    'UsernameContainsSpecialCharacters' => 'Username contains special characters. Use only {$special_characters}.',
    'PasswordCannotBeEmptyOrContainOnlySpaces' => 'Password cannot be empty or contain only spaces.',
    'UsernameExceedsTheMaximumAllowedLength' => 'Username exceeds the maximum allowed length.',
    'PasswordExceedsTheMaximumAllowedLength' => 'Password exceeds the maximum allowed length.',
    'UsernameIsTooShort' => 'Username is too short.',
    'PasswordIsTooShort' => 'Password is too short.',
    'TheControlAlreadyExists' => 'The control already exists.',
    'ANewControlWasAddedSuccessfully' => 'A new control was added successfully.',
    'TheControlNameCannotBeEmpty' => 'The control name cannot be empty.',
    'TheRoleNameCannotBeEmpty' => 'The role name cannot be empty.',
    'TheRoleNameAlreadyExists' => 'The role name already exists.',
    'AreYouSureYouWantToDeleteThisRole' => 'Are you sure you want to delete this role?',
    'FileType' => 'File Type',
    'FileExtension' => 'File Extension',
    'PleaseSelectAFileTypeBeforeDeleting' => 'Please select a file type before deleting.',
    'AreYouSureYouWantToDeleteThisFileType' => 'Are you sure you want to delete this file type?',
    'MissingFile' => 'Missing File',
    'ConfirmDeleteBackup' => 'Are you sure you want to delete this backup?',
    'DeleteBackup_Success' => 'Successfully removed backup.',
    'DeleteBackup_Expired_Success' => 'Successfully removed backup older than {$backup_remove} days: "{$parent_directory}".',
    'DeleteBackup_Cleanup_Success' => 'Backup directory "{$parent_directory}" was already deleted, cleaned up associated database entry.',
    'DeleteBackup_Failed' => 'Failed to remove backup directory "{$parent_directory}", not deleting the associated database entry.',
    'PleaseSelectAnExtensionBeforeDeleting' => 'Please select an extension before deleting.',
    'AreYouSureYouWantToDeleteThisExtension' => 'Are you sure you want to delete this extension?',
    'PleaseEnterAnEmailAddressBeforeSendingATestEmail' => 'Please enter an email address before sending a test email.',
    'PleaseSelectAValidFile' => 'Please select a valid file.',
    'PleaseEnterAValidExtension'  => 'Please enter a valid extension.',
    'TheFileTypeAlreadyExists' => 'The file type already exists.',
    'TheFileTypeExtensionAlreadyExists' => 'The file type extension already exists.',
    'TheFileTypeExtensionIsTooLong' => 'The file type extension is too long.',
    'EnterAValuationLevelName' => 'Enter a valuation level name.',
    'TheNameFieldCannotBeEmptyOrContainOnlySpaces' => 'The name field cannot be empty or contain only spaces.',
    'EditAsset' => 'Edit Asset',
    'TheSelectedControlsWereDeletedSuccessfully' => 'The selected controls were deleted successfully.',
    'NothingControlsForDeletingWereSelected' => 'Nothing controls for deleting were selected.',
    'PleaseSelectARoleBeforeDeleting' => 'Please select a role before deleting.',
    'DocumentInstallation' => 'Document Installation',
    'DocumentControlMapping' => 'Document to Control Mapping',
    'DocumentControlMappingHelp'=>'This report shows all document to control mappings',
    'DocumentID' => 'Document ID',
    'Score' => 'Score',
    'TFIDFSimilarity' => 'TF-IDF Similarity',
    'MatchingKeywords' => 'Matching Keywords',
    'AIMatch' => 'AI Match',
    'AIConfidence' => 'AI Confidence',
    'AIReasoning' => 'AI Reasoning',
    'DocumentColumns' => 'Document Columns',
    'ControlColumns' => 'Control Columns',
    'MatchingColumns' => 'Matching Columns',
    'ToBeDetermined' => 'To Be Determined',
    'Matching' => 'Matching',
    'Recommendation' => 'Recommendation',
    'AddControlToPolicy' => 'Add Control to Policy',
    'ConsiderAddingControl' => 'Consider Adding Control',
    'RemoveControlFromPolicy' => 'Remove Control from Policy',
    'NoActionRequired' => 'No Action Required',
    'DefiniteMatch' => 'Definite Match',
    'LikelyMatch' => 'Likely Match',
    'PossibleMatch' => 'Possible Match',
    'UnlikelyMatch' => 'Unlikely Match',
    'NotAMatch' => 'Not a Match',
    'ReviewManually' => 'Review Manually',
    'ResponsesToQuestionsWithLinkedControlsWillUpdateTheControlTypeTo' => 'Responses to questions with linked controls will update the control type to',
    'DueDate' => 'Due Date',
    'AuditLog_IncidentUpdated' => 'Incident "{$incident_summary}"(ID: {$incident_id}) was updated by user "{$user_name}". Changes: {$changes}.',
    'AnswersWillBeAutoSavedOnAssessments' => 'Answers will be auto-saved on assessments',
    'SecondsAssessmentsAreAutoSaved' => 'Seconds assessments are auto-saved',
    'NotifyOnAuditInitiate' => 'Notify on Initiated Audits',
    'NotifyAuditInitiateSubject' => 'Audit Initiated',
    'BypassPendingRisksAndCreateRisksImmediatelyAfterAssessmentCompletion' => 'Bypass \'Pending Risks\' and create Risks immediately after Assessment completion',
    'AssociatedExceptions' => 'Associated Exceptions',
    'Required' => 'Required',
    'EmailInstructions' => 'Email Instructions',
    'ApproveSelectedVulnerabilities' => 'Approve Selected Vulnerabilities',
    'RejectSelectedVulnerabilities' => 'Reject Selected Vulnerabilities',
    'DeleteSelectedQuestions' => 'Delete Selected Questions',
    'PleaseSelectAtLeastOneItemToDelete' => 'Please select at least one item to delete.',
    'AreYouSureYouWantToDeleteTheSelectedQuestions' => 'Are you sure you want to delete the selected question(s)?',
    'AssetAuditLogUpdate' => 'Asset "{$asset_name}" was updated by user "{$user}". Changes made: {$changes}.',
    'AssetAuditLogUpdateChange' => 'value of "{$key}" was changed from "{$value}" to "{$new_value}"',
    'AreYouSureYouWantToDiscardTheSelection' => 'Are you sure you want to discard the selection?',
    'AreYouSureYouWantToVerifyTheSelection' => 'Are you sure you want to verify the selection?',
    'Unapprove' => 'Unapprove',
    'ExceptionWasUnApprovedSuccessfully' => 'Exception was unapproved successfully.',
    'ExceptionAuditLogUnapprove' => 'Exception "{$exception_name}" was unapproved by user "{$user}".',
    'NormalizeScoringOnA0_10Scale' => 'Normalize scoring on a 0-10 scale.',
    'TheRiskScoreNormalizationSettingWasUpdatedSuccessfully_TheScoresOfExistingRisksWereRecalculatedBasedOnTheNewSetting' => 'The risk score normalization setting was updated successfully. The scores of existing risks were recalculated based on the new setting.',
    'DownloadFilePermissionMessage' => 'You do not have permission to download this file.',
    'Tab' => 'Tab',
    'TabOrdering' => 'Tab Ordering',
    'AutoInitiateAudit' => 'Automatically Initiate Audit',
    'AuditInitiationOffset' => 'Audit Initiation Offset',
    'AuditInitiationOffset_explanation' => 'days from Due Date',
    'AuditInitiationOffsetMustBeANonNegativeValue' => 'Audit Initiation Offset must be a non-negative value.',
    'AuditInitiationOffsetMustBeLessThanOrEqualToTestFrequency' => 'Audit Initiation Offset must be less than or equal to Test Frequency.',
    'BaseScore' => 'Base Score',
    'TemporalScore' => 'Temporal Score',
    'EnvironmentalScore' => 'Environmental Score',
    'ExploitabilityScore' => 'Exploitability Score',
    'ImpactScore' => 'Impact Score',
    'ImpactMetrics' => 'Impact Metrics',
    'ImpactSubscoreModifiers' => 'Impact Subscore Modifiers',
    'SaveCVSSScore' => 'Save CVSS Score',
    'ExploitabilityMetrics' => 'Exploitability Metrics',
    'CVSSScore' => 'CVSS Score',
    'CVSS2Calculator' => 'CVSS v2 Calculator',
    'TheFileTypeWithThisExtensionAlreadyExists' => 'The file type with this extension already exists.',
    'AnExistingUploadFileTypeWasRemovedSuccessfully' => 'An existing upload file type was removed successfully.',
    'AnExistingUploadFileExtensionWasRemovedSuccessfully' => 'An existing upload file extension was removed successfully.',
    'UploadingFileTypeAndExtensionNoSupport' => 'The file type and extension combination ("{$file_type_name}", "{$file_type_extension_name}") is not supported.',
    'Logging' => 'Logging',
    'EnableLoggingCritical' => 'CRITICAL: Conditions that may require immediate action.',
    'EnableLoggingError' => 'ERROR: Runtime errors that require attention but don’t crash the app.',
    'EnableLoggingWarning' => 'WARNING: Something unexpected happened, but the app is still running.',
    'EnableLoggingNotice' => 'NOTICE: Normal but significant events that deserve attention.',
    'EnableLoggingInfo' => 'INFO: General informational messages that highlight normal operations.',
    'EnableLoggingDebug' => 'DEBUG: Detailed diagnostic information for developers.',
    'QueueMonitor' => 'Queue Monitor',
    'PleaseEnterAValidTimezone' => 'Please enter a valid timezone.',
    'TFIDFMatch' => 'TF-IDF Match',
    'CompletionDate' => 'Completion Date',

    '' => '',
);
?>
